<?php

/** @CreatedBy : Mohit Jain
 *  @Description : User Model Functions
 */

namespace User\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Registration extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO VERIFY REGISTER USER
     * @param $data
     * @returns $responsedata
     */

    public function verifyRegisterUser($username){
        $url = $this->apiUrl() . "/user/verifyregister?username=" . $username;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO VERIFY USER
     * @param $data
     * @returns $responsedata
     */

    public function verifyUser($email,$mobile,$registrationType){
        $url = $this->apiUrl() . "/user/verifysignup?email=" . $email ."&mobile=" .$mobile ."&user_type_id=" .$registrationType;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO ADD USER SIGNUP
     * @param $data
     * @returns $responsedata
     */

    public function userSignup($data){
        $url = $this->apiUrl() . "/user/signup";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO ADD NEW USER SIGNUP
     * @param $data
     * @returns $responsedata
     */

    public function userNewSignup($data){
        $url = $this->apiUrl() . "/user/newsignup";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO UPDATE PERSONAL INFO
     * @param $data
     * @returns $responsedata
     */

    public function updatePersonalInfo($data){
        $url = $this->apiUrl() . "/user/updatepersonalinfo";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO UPDATE SIGNUP STATUS
     * @param $data
     * @returns $responsedata
     */

    public function updateSignupStatus($data){
        $url = $this->apiUrl() . "/user/updatesignupstatus";
        $val = $this->put($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET USER PERSONAL INFO
     * @param $data
     * @returns $responsedata
     */

    public function getUserPersonalInfo($user_id){
        $url = $this->apiUrl() . "/user/userpersonalinfo?user_id=" . $user_id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO RESENT OTP
     * @param $data
     * @returns $responsedata
     */
    
    public function resentOtp($user_id){
        $data = [];
        if ($user_id > 0) {
            $url = $this->apiUrl() . "/user/resendotp?user_id=" . $user_id;
            $resp = $this->get($url);
            $data = Json::decode($resp->getBody(), true);
            return $data;
        } else {
            return $data;
        }
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET VEHICLE COLOUR
     * @param $data
     * @returns $responsedata
     */
    
    public function getVehicleColour(){
        $colourDataArray = [];
        $url = $this->apiUrl()."/vehicle-master/vehiclecolour";
        $resp = $this->get($url);
        $colourData = Json::decode($resp->getBody(), true);
       
        if($colourData['responsedata']['status']=='success'){
            foreach ($colourData['responsedata']['data'] as $res) {
                $colourDataArray[$res['colour_id']] = $res['colour_name'];
            }
        }
        return $colourDataArray;      
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION TO GET VEHICLE MODEL YEAR
     * @param $data
     * @returns $responsedata
     */

    public function getVehileModelYear(){
        $vehicleModelArr = [];
        $url = $this->apiUrl()."/vehicle-master/vehicleyear";
        $resp = $this->get($url);
        $yearData = Json::decode($resp->getBody(), true);
       
        if($yearData['responsedata']['status']=='success'){
            foreach ($yearData['responsedata']['data'] as $res) {               
                $vehicleModelArr[$res['year']] = $res['year'];
            }        
                return $vehicleModelArr;  
        }
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2017
     * @description : FUNCTION FOR THANKS REGISTRATION
     * @param $data
     * @returns $responsedata
     */
        
    public function registrationThanks($data){
        $url = $this->apiUrl() . "/user/registrationThanks";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $result = Json::decode($JsonData, true);
        return $result;
    }

}
