<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class VendorRegistrationForm extends Form implements InputFilterProviderInterface{
    
    
    public function __construct($name = null) {

        /**
         * Login Detail Form of Vendor Registration
         */  
        parent::__construct('vendor-registration-form');
        $this->setAttribute('method', 'post');        

        /**
         * username
         */
        $this->add([
            'name' => 'username',
            'type' => 'text',
            'attributes' => [
                'id' => 'username',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => 'password',
            'attributes' => [
                'id' => 'password',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => 'password',
            'attributes' => [
                'id' => 'confirm-password',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Registration Type
         */
        $this->add([
            'name' => 'registration_type',
            'type' => 'hidden',
            'attributes' => [
                'id' => 'registration-type',                
                'class' => 'form-control'
            ]            
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'login_detail',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Continue',
                'id' => 'login-detail',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
       
    }

    
    public function getInputFilterSpecification() {
        return [
            'username' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter username'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
         
            'password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'confirm_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter confirm password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            
            
            
        ];
    }
}
