<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Text,
    Submit,
    Hidden,
    Password,
    Checkbox
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class RegistrationForm extends Form implements InputFilterProviderInterface {

    public static $nationalityList = [];
    public static $countryprefix = [];

    public function __construct($name = null) {

        /**
         * Login Detail Form of Driver Registration
         */
        parent::__construct('registration-form');
        $this->setAttribute('method', 'post');

        /**
         * first_name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'class' => 'form-control inputuppercase',
                'maxlength'=>60,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'First name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * last_name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',
                'class' => 'form-control inputuppercase',
                'maxlength'=>60,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Last name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * username
         */
        $this->add([
            'name' => 'username',
            'type' => Text::class,
            'attributes' => [
                'id' => 'username',
                'class' => 'form-control user-name'
            ],
            'options' => [
                'label' => 'Username (User Login Id)',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase personalemail'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Mobile no Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'class' => 'form-control',
                 'value'  => '91',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$countryprefix,
                'disable_inarray_validator' => true,
            ],
        ]);

         /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'class' => 'form-control input-border user-contact',
                'min' => 1,
                'max' => 10,
                'maxlength'=>10,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No <span class="mandat_star red_text">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);


        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'password',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'confirm-password',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Referenced By
         */
        $this->add([
            'name' => 'reference_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reference-name',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Refer By (Ref Code)',
            ],

        ]);

        /**
         * Registration Type
         */
        $this->add([
            'name' => 'registration_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control'
            ]
        ]);

        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Select::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'form-control form-control input-border'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$nationalityList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'form-control form-control input-border nationality-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>'
            ]
        ]);

        /**
         * Nationality Value
         */
        $this->add([
            'name' => 'nationality_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'nationality-value'
            ],
        ]);

        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'agreeterms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agreeterms',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);


        /**
         * Continue
         */
        $this->add([
            'name' => 'login_detail',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Continue',
                'id' => 'login-detail',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'username' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter username'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'confirm_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter confirm password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           'contact_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 8,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
        'agreeterms'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'You must agree to the terms of use.',
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]
        ];
    }

}
