<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Email,
    Checkbox,
    File,
    Text,
    Textarea,
    Submit,
    Button,
    Hidden,
    Password
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength,
    Identical
};
use Zend\InputFilter\InputFilterProviderInterface;

class PersonalRegistrationForm extends Form implements InputFilterProviderInterface {

     public static $countryprefix = [];
    public function __construct($name = null) {

        /**
         * Personal Detail Form of Driver Registration
         */
        parent::__construct('personal-registration-form');
        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');

        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'First Name',
                'class' => 'form-control input-border inputuppercase',
                'maxlength' => 60,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                //'class' => 'control-label col-sm-3 col-lg-3',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'maxlength' => 60,
                'id' => 'last-name',
                'placeholder' => 'Last Name',
                'class' => 'driver_name input-border col-sm-6 col-lg-5 inputfild form-control inputuppercase',
                'onkeypress' => "return isAlphaNumber(event)"
            ]
        ]);

        /**
         * Father's Name
         */
        $this->add([
            'name' => 'father_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'father-name',
                'maxlength' => 100,
                'placeholder' => 'Father\'s Name',
                'class' => 'driver_name form-control inputuppercase',
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Father\'s Name<span style="color: red"></span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase personalemail'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Mobile No Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'value' => '+91',
                'disabled' => true,
                //'class' => 'form-control',
                 'placeholder' => '',
                 'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'value_options' => self::$countryprefix,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'class' => 'form-control input-border user-contact',
                'min' => 1,
                'max' => 10,
                'maxlength' => 10,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Contact No <span class="mandat_star red_text">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Alt Contact No Prefix
         */
        $this->add([
            'name' => 'prefix_alt_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-alt-contact-no',
                //'value' => '+91',
                //'disabled' => true,
                //'class' => 'form-control'
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Alternate Contact No.',
                'value_options' => self::$countryprefix,
            ],
        ]);

        /**
         * Alt Contact No
         */
        $this->add([
            'name' => 'alt_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alt-contact-no',
                'class' => 'form-control',
                'maxlength' => 10,
                'max' => 10,
                'min' => 8,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Alternate Contact No.'
            ],
        ]);

        /**
         * Referenced By
         */
        $this->add([
            'name' => 'reference_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reference-name',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Refer By (Ref Code)',
            ],
        ]);


        /**
         * Referral user id
         */
        $this->add([
            'name' => 'referral_by',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'referral_by'
            ],
        ]);


        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dob',
                'class' => 'form-control dob'
            ],
            'options' => [
                'label' => 'DOB<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Residential Address
         */
        $this->add([
            'name' => 'residential_address',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'residential-address',
                'rows' => '5',
                'cols' => '8',
                'class' => 'form-control inputuppercase'
            ],
            'options' => [
                'label' => 'Residential Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Residential Proof
         */
        $this->add([
            'name' => 'residential_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'residential-proof',
                'class' => 'form-control common-upload-file',
                 'data-level-name' => 'residential_proof',
            ]
        ]);

        /**
         * Select City
         * ui-autocomplete-input form-control uppercase
         */
        $this->add([
            'name' => 'city_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-id',
                'class' => 'form-control uppercase city-class',
                'maxlength' => 50,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);

        /**
         * Pin Code
         */
        $this->add([
            'name' => 'pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pincode',
                'maxlength' => 6,
                'class' => 'form-control uppercase',
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Pin Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle Code
         */
        $this->add([
            'name' => 'vehicle_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-code',
                'placeholder' => 'DL',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Vehicle No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle No
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => '10F1530',
                'class' => 'form-control uppercase'
            ]
        ]);

        /**
         * Upload Your RC Proof
         */
        $this->add([
            'name' => 'rc_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'rc-proof',
                'class' => 'form-control'
            ]
        ]);

        /**
         * License State
         */
        $this->add([
            'name' => 'license_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'license-no',
                'maxlength' => 50,
                'class' => 'form-control uppercase',
                'onkeypress' => 'return isAlphaNumber(event)'
            ],
            'options' => [
                'label' => 'License No.<span style="color: red"> </span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * License Proof.
         */
        $this->add([
            'name' => 'license_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'license-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'license_proof',
            ], 'options' => [
                'label' => 'License Proof',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License Proof.
         */
        $this->add([
            'name' => 'registration_certificate',
            'type' => File::class,
            'attributes' => [
                'id' => 'registration-certificate',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'registration_certificate',
            ], 'options' => [
                'label' => 'Registration Certificate',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Accept the Terms and Conditions
         */
        /*$this->add([
            'name' => 'agreeterms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agreeterms',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);*/

        /**
         * Guide higher certificate.
         */
        $this->add([
            'name' => 'guide_certificate',
            'type' => File::class,
            'attributes' => [
                'id' => 'guide-certificate',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'guide_certificate'
            ],
            'options' => [
                'label' => 'Higher Education Certificate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ]
        ]);


        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_personal_detail',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Submit',
                'id' => 'driver-personal-detail',
                'class' => 'btn btn-primary btn-lg pull-right personal-btn'
            ],
        ]);


        $this->add([
            'name' => 'signup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'personal-registration-form-btn',
                'class' => 'btn btn-info form-control',
                'value' => 'Submit',
                'onclick' => "submitForm('#personal-registration-form', event);"
            ],
        ]);

        /**
         * Registration Type
         */
        $this->add([
            'name' => 'registration_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control'
            ]
        ]);

        /**
         * Email Status
         */
        $this->add([
            'name' => 'email_status',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'email-status'
            ],
        ]);

        /**
         * Mobile Status
         */
        $this->add([
            'name' => 'mobile_status',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'contact-no-status'
            ],
        ]);


        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'password',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'confirm-password',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'form-control form-control input-border nationality-class'
            ], 'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'contact_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'prefix_contact_no' => [
                'required' => false,
            ],

            'password' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 6,
                            'max' => 20,
                            'messages' => [
                                StringLength::TOO_SHORT => 'Password should be greater than 6 and smaller than 20',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'confirm_password' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter confirm password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 6,
                            'max' => 20,
                            'messages' => [
                                StringLength::TOO_SHORT => 'Confirm password should be greater than 6 and smaller than 20',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Identical',
                        'options' => [
                            'token' => 'password',
                            'messages' => [
                                Identical::NOT_SAME => 'Please enter same password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'nationality' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /**
             * Date Of Birth
             */
            'dob' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Date Of Birth'
                            ]
                        ],
                    ],
                ]
            ],
            /**
             * Residential Address
             */
            'residential_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Residential Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /**
             * Residential Proof
             */
            'residential_proof' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'File was not uploaded'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'FileUploadFile'],
                    [
                        'name' => 'FileMimeType',
                        'options' => [
                            'mimeType' => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'FileIsImage'],
                    [
                        'name' => 'FileImageSize',
                        'options' => [
                            'minWidth' => 128,
                            'minHeight' => 128,
                            'maxWidth' => 4096,
                            'maxHeight' => 4096
                        ]
                    ],
                ]
            ],
            /**
             * City
             */
            'city_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_code' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Vehicle Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /**
             * Vehicle No
             */
            'vehicle_number' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Vehicle No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            /**
             * Upload Your RC Proof
             */
//       'rc_proof'=>[
//            'required' => true,
//            'filters' => [
//                ['name' => 'StripTags'],
//                ['name' => 'StringTrim']
//            ],
//            'validators' => [
//                [   'name' => 'NotEmpty',
//                    'options' => [
//                        'messages' => [
//                            NotEmpty::IS_EMPTY => 'File was not uploaded'
//                        ]
//                    ],
//                    'break_chain_on_failure' => true
//                ],
//                ['name'    => 'FileUploadFile'],
//                [
//                    'name'    => 'FileMimeType',
//                    'options' => [
//                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
//                    ],
//                    'break_chain_on_failure' => true
//                ],
//                ['name'    => 'FileIsImage'],
//                [
//                        'name'    => 'FileImageSize',
//                        'options' => [
//                            'minWidth'  => 128,
//                            'minHeight' => 128,
//                            'maxWidth'  => 4096,
//                            'maxHeight' => 4096
//                        ]
//                ],
//            ]
//        ],

            /**
             * License State
             */
            'license_no' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select License State'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'license_proof' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'File was not uploaded'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'FileUploadFile'],
                    [
                        'name' => 'FileMimeType',
                        'options' => [
                            'mimeType' => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'FileIsImage'],
                    [
                        'name' => 'FileImageSize',
                        'options' => [
                            'minWidth' => 128,
                            'minHeight' => 128,
                            'maxWidth' => 4096,
                            'maxHeight' => 4096
                        ]
                    ],
                ]
            ]
        ];
    }

}
