<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\Date;
use Zend\Form\Element\Email;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Hidden;

class GuidePersonalRegistrationForm extends Form {
    
    public  $licenseStateList = ['1' => 'Delhi', '2' => 'Haryana', '3' => 'Uttar Pardesh', '4' => 'Bihar', '5' => 'Punjab'];
    
    public function __construct($name = null) {

        /**
         * Personal Detail Form of Guide Registration
         */  
        parent::__construct('guide-personal-registration-form');
        $this->setAttribute('method', 'post'); 
        $this->setAttribute('enctype', 'multipart/form-data');  

        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',                
                'placeholder' => 'First Name',
                'class' => 'driver_name form-control uppercase'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                //'class' => 'control-label col-sm-3 col-lg-3',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',    
                'placeholder' => 'Last Name',
                'class' => 'driver_name col-sm-6 col-lg-5 inputfild form-control uppercase'
            ]
            
        ]);     
        
        /**
         * Father's Name
         */
        $this->add([
            'name' => 'father_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'father-name',    
                'placeholder' => 'Father\'s Name',
                'class' => 'driver_name form-control uppercase'
            ],
            'options' => [
                'label' => 'Father\'s Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);  
        
        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Email::class,
            'attributes' => [
                'id' => 'email',    
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);  
        
        /**
         * Mobile No Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefix-contact-no',  
                'value' => '+91',
                'disabled' => true,
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',                
                'class' => 'form-control'
            ]            
            
        ]); 
        
        /**
         * Alt Contact No Prefix
         */
        $this->add([
            'name' => 'prefix_alt_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefix-alt-contact-no',  
                'value' => '+91',
                'disabled' => true,
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Alternate Contact No.'                
            ],
            
        ]); 
        
        /**
         * Alt Contact No
         */
        $this->add([
            'name' => 'alt_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'alt-contact-no',                
                'class' => 'form-control'
            ]            
            
        ]);
        
        /**
         * Referenced By
         */
        $this->add([
            'name' => 'reference_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'reference-name',                    
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Referenced By'                
            ],
            
        ]);  
        
        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'type' => Date::class,
            'attributes' => [
                'id' => 'dob',                    
                'class' => 'form-control hasDatepicker'
            ],
            'options' => [
                'label' => 'Date Of Birth<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * Residential Address
         */
        $this->add([
            'name' => 'residential_address',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'residential-address',
                'rows' => '5',
                'cols' => '8',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Residential Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * Residential Proof
         */
//        $this->add([
//            'name' => 'residential_proof',
//            'type' => File::class,
//            'attributes' => [
//                'id' => 'residential-proof',                
//                'class' => 'form-control'
//            ]           
//            
//        ]); 
        
        /**
         * Select City
         * ui-autocomplete-input form-control uppercase
         */
        $this->add([
            'name' => 'city_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-id',                    
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Select City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);
        
        /**
         * Pin Code
         */
        $this->add([
            'name' => 'pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pincode',                    
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Pin Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]);
        
        /**
         * Vehicle Code
         */
//        $this->add([
//            'name' => 'vehicle_code',
//            'type' => Text::class,
//            'attributes' => [
//                'id' => 'vehicle-code',
//                'placeholder' => 'DL',
//                'class' => 'form-control uppercase'
//            ],
//            'options' => [
//                'label' => 'Vehicle No.<span style="color: red"> *</span>',
//                'label_options' => ['disable_html_escape' => true]
//            ],
//            
//        ]); 
        
        /**
         * Vehicle No
         */
//        $this->add([
//            'name' => 'vehicle_number',
//            'type' => Text::class,
//            'attributes' => [
//                'id' => 'vehicle-number',
//                'placeholder' => '10F1530',
//                'class' => 'form-control uppercase'
//            ]            
//            
//        ]); 
        
        /**
         * Upload Your RC Proof
         */
//        $this->add([
//            'name' => 'rc_proof',
//            'type' => File::class,
//            'attributes' => [
//                'id' => 'rc-proof',                
//                'class' => 'form-control'
//            ]           
//            
//        ]); 
        
        /**
         * Company Name
         */
        $this->add([
            'name' => 'company_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-name',
                //'placeholder' => 'DL',
                'class' => 'form-control uppercase'
            ],
            'options' => [
                'label' => 'Company Name.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
            
        ]); 
        
        /**
         * License State
         */
        $this->add([
            'name' => 'license_state',
            'type' => Text::class,
            'attributes' => [
                'id' => 'state-id',                    
                'class' => 'form-control driver_pref_city uppercase'
            ],
            'options' => [
                'label' => 'License State<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]                
            ],
            
        ]); 
        
        /**
         * State Value
         */
        $this->add([
            'name' => 'license_state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'license-state-value'
            ],
        ]);
        
        /**
         * License Proof.
         */
        $this->add([
            'name' => 'license_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'license-proof',                
                'class' => 'form-control'
            ]           
            
        ]);  
        
        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'driver_personal_detail',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Submit',
                'id' => 'driver-personal-detail',
                'class' => 'btn btn-primary btn-lg pull-right'
            ],
        ]);
       
    }

}
