<?php

namespace User\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Text,
    Submit,
    Select,
    Password,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class AddNewUserHotelForm extends Form implements InputFilterProviderInterface {

    public static $usertype = [];
    public static $gender = ['Male' => 'Male', 'Female' => 'Female'];
    public static $countryprefix = [];
    public static $dutytype = [];
    public function __construct($name = null) {

        parent::__construct('add-new-user-form');
        $this->setAttribute('method', 'post');
        
        
        /**
         * Duty Type
         */
        $this->add([
            'name' => 'duty_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'duty-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Services<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$dutytype,
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Company Name
         */
        $this->add([
            'name' => 'company_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-name',
                'placeholder' => 'Company Name',
                'class' => 'form-control inputuppercase',
                'maxlength' => 50,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Company Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        
        /**
         * Mobile no Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'class' => 'form-control',
                 'value'  => '91',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$countryprefix,
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         * Login Id...
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'username',
                'placeholder' => 'Email',
                'class' => 'form-control inputchange login-id user-name'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'placeholder' => 'Mobile No',
                'class' => 'form-control input-border user-contact',
                'min' => 1,
                'max' => 10,
                'maxlength'=>10,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);


        /**
         *Password...
         */
        $this->add([
            'name' => 'password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'password',
                'placeholder' => 'password',
                'class' => 'form-control inputchange pwd'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         *Confirm Password...
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => Text::class,
            'attributes' => [
                'id' => 'confirm-password',
                'placeholder' => 'Confirm password',
                'class' => 'form-control inputchange conf-password'
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

         /**
         * User Type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$usertype,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select User Type',
            ]
        ]);

         /**
         * Gender
         */
        $this->add([
            'name' => 'gender',
            'type' => Select::class,
            'attributes' => [
                'id' => 'gender',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Gender<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$gender,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select Gender',
            ],
        ]);


        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'First Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * First Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'last-name',
                'placeholder' => 'Last Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'placeholder' => 'Nationality',
                'class' => 'form-control form-control input-border nationality-class'
            ],
            'options' => [
                 'label_options' => ['disable_html_escape' => true],
                'label' => 'Nationality<span style="color: red"> *</span>'
            ]
        ]);
        
        /**
         * Pref City to Drive Cab
         */

        $this->add([
            'name' => 'preferred_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Expertisse in (Geography): Destinations<span style="color: red">*</span>',
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
            ],
        ]);

        
         /**
         * Nationality Value
         */
        $this->add([
            'name' => 'nationality_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'nationality-value'
            ],
        ]);


        /**
         * Save...
         */
        $this->add([
            'name' => 'save_login_detail',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-login-detail',
                'value' => 'Save',
                'class' => 'btn btn-info col-sm-2 pull-right',
                'onclick' => "submitForm('#add-new-user-form', event);"
            ],

        ]);



    }

        public function getInputFilterSpecification() {
        return [
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           'contact_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],
            'first_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter First Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'last_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Last Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'user_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'gender' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Gender'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter password'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'company_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Company name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'preferred_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter city'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'duty_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter duty type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


        ];
    }

}
