<?php
namespace Outstation\Form;

use Outstation\Entity\MultiCityProduct;
use Zend\Form\Fieldset;
use Zend\Form\Element\Collection;
use Zend\Hydrator\ClassMethods;
use Outstation\Form\MultiCityItemFieldset;

class MultiCityFieldset extends Fieldset
{
    public function __construct($name = null, $options = array())
    {

        parent::__construct($name, $options);

        $this->setHydrator(new ClassMethods(false));
        $this->setObject(new MultiCityProduct());

        // Fieldset for ITEM belonging to product - inject the attribute manager to retrieve attributes for each item:
        $item = new MultiCityItemFieldset('Item-details',null);

        $this->add(array(
            'name' => 'items',
            'type' => Collection::class,
            'options' => array(
                //https://zendframework.github.io/zend-form/element/collection/
                'should_create_template' => true,
                'allow_add' => true,
                'allow_remove' =>true,
                'count' => 2,
                'target_element' =>  $item,
                'template_placeholder' => '__placeholder__',

            )
        ));
    }
}