<?php

namespace Guide\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class VehicleSearchForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('vehicle-search-form');

        $this->setAttribute('method', 'post');


        //Please Select City

        $this->add([
            'name' => 'pickup_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-city',
                'placeholder' => '',
                'class' => 'pickup-city inputMaterial'
            ],
        ]);


        //to
        $this->add([
            'name' => 'drop_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-city',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'To',
            ],
        ]);

        //Pickup date
        $this->add([
            'name' => 'pickup_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-date',
                'placeholder' => '',
                'class' => 'regencydatepicar inputMaterial departuredate'
            ],
            'options' => [
                'label' => ''
            ]
        ]);

        //Pickup Time
        $this->add([
            'name' => 'pickup_time',
            'type' =>  Text::class,
            'attributes' => [
                'id' => 'pickup-time',
                'placeholder' => 'Time',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => ''
            ]
        ]);

        //Please Select Package
        $this->add([
            'name' => 'guide_package',
            'type' => Select::class,
            'attributes' => [
                'id' => 'guide-package',
                'class' => 'inputMaterial',
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => '  ',
                'value_options' => [
                    'volvo' => 'Half Day',
                    'saab' => 'Full Day',
                    
                ],
            ],
        ]);

        //No of days
        $this->add([
            'name' => 'number_of_days',
            'type' =>  Text::class,
            'attributes' => [
                'id' => 'number-of-days',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => ''
            ]
        ]);

        //Number of adult
        $this->add([
            'type' => Number::class,
            'name' => 'adults',
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => '',
                'options' => [],
            ],
        ]);

        //Number of child
        $this->add([
            'type' => Number::class,
            'name' => 'childs',
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => '',
                'options' => [],
            ],
        ]);

        //Number of guides
        $this->add([
            'type' => Number::class,
            'name' => 'guides',
            'attributes' => [
                'id' => 'guides',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => '',
                'options' => [],
            ],
        ]);

        //Guide Language*
        $this->add([
            'name' => 'guide_language',
            'type' => Text::class,
            'attributes' => [
                'id' => 'guide-language',
                'placeholder' => ' ',
                'class' => 'inputMaterial'
            ]
        ]);

        //Select Country
        $this->add([
            'name' => 'pickup_country',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-country',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
        ]);

        //Pickup address*
        $this->add([
            'name' => 'pickup_address',
            'type' => Text::class,
            'attributes' => [
                'id' => '',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Pickup address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        //Terms and conditions
        $this->add([
            'name' => 'agreeterms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agreeterms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true,
            ],
        ]);

        // Tour type

        $this->add([
            'name' => 'tour_type',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tour-type',
                'placeholder' => '',
                'class' => 'inputMaterial'
            ]
        ]);


        //submit button
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search Guide',
                'id' => 'submitbutton',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'pickup_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                            'messages' => [
                                \Zend\Validator\Date::INVALID_DATE => '',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'pickup_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_country' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Tour Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'guide_language' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Guide language'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'drop_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Drop Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'airport' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Airport'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'adults' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Adult'
                            ]
                        ],
                    ],
                ]
            ],
            'childs' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Child'
                            ]
                        ],
                    ],
                ]
            ],
            'luggages' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Luggage'
                            ]
                        ],
                    ],
                ]
            ],
            'no_of_vehicles' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Vehicles'
                            ]
                        ],
                    ],
                ]
            ],
            'agree_terms' => [
                'required' => true,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
