<?php

/** @CreatedBy : Mohit verma
 *  @Description : Common Model Functions
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class CommonModel extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    /** @CreatedBy : Mohit Verma
     *   @Description : Get Department Name By User Id
     *  @param : User Id
     */
    public function getDepartmentByuserId($userId) {
        $JsonDataArray = [];
        $val = '{"where": {"created_by": "' . $userId . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/department?&filter=" . $val;
        $resp = $this->get($url);
        $kycTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($kycTypeJsonData as $res) {
            $JsonDataArray[$res['id']] = $res['department_name'];
        }
        return $JsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE PACKAGE TYPE LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($packageTypeJsonData['data']) > 0) {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $packageTypeJsonDataArray;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE PACKAGE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getPackageListAction($booking_type_id) {
        $packageTypeJsonDataArray = [];
        $postData = $this->getRequest()->getPost();
        $val = '{"where": {"booking_type_id": "' . $booking_type_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package?&filter=" . $val;
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if ($packageTypeJsonData['status']=="success") {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
       return $packageTypeJsonDataArray;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE BOOKING MODULE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getBookingModuleList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-booking-type";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($packageTypeJsonData['data']) > 0) {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['booking_type'];
            }
        }
        return $packageTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE TOUR TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getTourTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/tour-type";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($packageTypeJsonData['data']) > 0) {
            foreach ($packageTypeJsonData['data'] as $res) {
                $packageTypeJsonDataArray[$res['id']] = $res['tour_type'];
            }
        }
        return $packageTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE PACKAGE MODE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getPackageModeList() {
        $packageModeJsonDataArray = [];
        $url = $this->apiUrl() . "/package-mode";
        $resp = $this->get($url);
        $packageModeJsonData = Json::decode($resp->getBody(), true);
        foreach ($packageModeJsonData as $res) {
            $packageModeJsonDataArray[$res['id']] = $res['package_mode'];
        }
        return $packageModeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE DOCUMENT TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getDocumentTypeByName($documentName) {
        $response = [];
        if (isset($documentName) && $documentName != '') {
            $val = '{"where": {"doc_level_name":"' . $documentName . '"}}';
            $val = rawurlencode($val);
            $url = $this->apiUrl() . "/document-type?&filter=" . $val;
            $resp = $this->get($url);
            return $response = Json::decode($resp->getBody(), true);
        } else {
            return $response;
        }
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : API TO UPLOAD IMAGE
     * @param $data
     * @returns $responsedata
     */
    
    public function uploadimageapi($arrval = array()) {
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $arrval);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE CITY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getCitydetail($cityid) {
        $url = $this->apiUrl() . "/city/stateCountryByCityName?cityid=" . $cityid;
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        $cityData = $cityJsonData['response']['data'][0];
        return $cityData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE AIRPORT RAILWAY UPDATE STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateAirportStatus($data) {
        $url = $this->apiUrl() . "/airport-railway/updateStatus";
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE LOCAL PACKAGE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getLocalPkg() {
        $url = $this->apiUrl() . "/local-package/getlocalpkg";
        $resp4 = $this->get($url);
        $localPackageData = Json::decode($resp4->getBody(), true);
        return $localPackageData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE VEHICLE COLOUR  LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleColour() {
        $url = $this->apiUrl() . "vehicle-master/vehiclecolour";
        $resp = $this->get($url);
        $colourData = Json::decode($resp->getBody(), true);
        return $colourData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE SIGHTSEEING CATEGORY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getSightseeingCategory() {
        $sightseeing_category = [];
        $url = $this->apiUrl() . "/master-tour-theme";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);

        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $sightseeing_category[$value['id']] = $value['theme_name'];
            }
        }
        return $sightseeing_category;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE INCLUSION LIST
     * @param $data
     * @returns $responsedata
     */

    public function getInclusionList() {
        $data = [];
        $inclusionJsonDataArray = [];
        $url = $this->apiUrl() . "/inclusion/getInclusionDetails";
        $resp = $this->post($url, $data);
        $inclusionJsonData = Json::decode($resp->getBody(), true);
        if ($inclusionJsonData['responsedata']['status'] == "success") {
            foreach ($inclusionJsonData['responsedata']['data'] as $res) {
                $inclusionJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $inclusionJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE TOUR CATEGORY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getTourCategoryList() {
        $data = [];
        $inclusionJsonDataArray = [];
        $url = $this->apiUrl() . "/master-tour-category/getTourCategoryDetails";
        $resp = $this->post($url, $data);
        $inclusionJsonData = Json::decode($resp->getBody(), true);
        if ($inclusionJsonData['responsedata']['status'] == "success") {
            foreach ($inclusionJsonData['responsedata']['data'] as $res) {
                $inclusionJsonDataArray[$res['tour_category_id']] = $res['tour_category_name'];
            }
        }
        return $inclusionJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE SIGHTSEEING TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getSightseeingType() {
        $sightseeing_type = [];
        //$url = $this->apiUrl() . "/master-sightseeing-type";
        $url = $this->apiUrl() . "/master-sightseeing-category";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);

        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $sightseeing_type[$value['id']] = $value['name'];
            }
        }

        return $sightseeing_type;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE THINGS TO CARRY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getThingsToCarry() {
        $getThingsToCarry = [];
        $url = $this->apiUrl() . "/master-things-carry";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);

        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $getThingsToCarry[$value['id']] = $value['name'];
            }
        }
        return $getThingsToCarry;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE MEALS LIST
     * @param $data
     * @returns $responsedata
     */

    public function getMeals() {
        $getMeals = [];
        $url = $this->apiUrl() . "/master-meal-type";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);

        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $getMeals[$value['id']] = $value['meal_name'];
            }
        }
        return $getMeals;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE VEHICLE TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehType() {

        $getVehType = [];
        $url = $this->apiUrl() . "/master-veh-type";
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);

        if (count($jsonResponse) > 0) {
            foreach ($jsonResponse as $key => $value) {
                $getVehType[$value['id']] = $value['tour_pax'];
            }
        }
        return $getVehType;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE JOBS DETAILS DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getJobDetails() {
        $val = '{"where": {"status": {"neq": 2}}}';
        $val = rawurlencode($val);
        //$url = $this->apiUrl() . "/department-jobs?&filter=" . $val;
        $url = $this->apiUrl() . "/department-jobs?&filter=" . $val;
        $resp = $this->get($url);
        $responseData = Json::decode($resp->getBody(), true);
        return $responseData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE USER JOBS DETAILS DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserJobDetails($data) {
        $url = $this->apiUrl() . "/department-jobs/" . $data;
        $resp = $this->get($url);
        $responseData = Json::decode($resp->getBody(), true);
        return $responseData;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO INSERT THE NEW JOBS DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function addNewJob($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/department-jobs";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE JOB DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateJobs($data) {
        $val = '{"id": "' . $data['id'] . '"}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/department-jobs/update?where=" . $val;
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE MULTIPLE JOBS STATUS
     * @param $data
     * @returns $responsedata
     */

    public function multiupdateJobs($data) {
        $url = $this->apiUrl() . "/department-jobs/updateStatus";
        $resp = $this->put($url, $data);
        $JsonData = Json::decode($resp->getBody(), true);
        return $JsonData;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FILTER THE JOBS DATA
     * @param $data
     * @returns $responsedata
     */

    public function filterJobs($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/department-jobs/deptjobs";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE BOOKING TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getBookingTypeList() {
        $bookingTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-booking-type";
        $resp = $this->get($url);
        $bookingTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($bookingTypeJsonData['data']) > 0) {
            foreach ($bookingTypeJsonData['data'] as $res) {
                $bookingTypeJsonDataArray[$res['id']] = $res['booking_type'];
            }
        }
        return $bookingTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE CANCELLATION TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getCancellationTypeList() {
        $cancellationTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/cancellation-list";
        $resp = $this->get($url);
        $cancellationTypeJsonData = Json::decode($resp->getBody(), true);
        if (count($cancellationTypeJsonData['data']) > 0) {
            foreach ($cancellationTypeJsonData['data'] as $res) {
                $cancellationTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $cancellationTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD THE USER TAX DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addUserTaxDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/addtaxdetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD THE FARE SETTINGS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addUserFareSettingDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserbasicfare";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE USER TAX DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getUserTaxDetail($user_id, $masterBookType, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getusertaxdetail?user_id=" . $user_id . "&master_booking_type_id=" . $masterBookType . "&id=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE USER TAX DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updatetUserTaxDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updatetaxdetail";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE FARE SETTINGS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateUserFareSettingDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateuserfaresetting";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE FARE SETTING LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getFareSettingDetail($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getfaresettingdetail?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER CANCELLATION FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserCancellationFare($user_id, $masterBookType, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getusercancellationfare?user_id=" . $user_id . "&master_booking_type_id=" . $masterBookType . "&booking_type=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH DRIVER CANCELLATION FARE DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getDriverCancellationFare($user_id, $masterBookType, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getdrivercancellationfare?user_id=" . $user_id . "&master_booking_type_id=" . $masterBookType . "&booking_type=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addUserCancellationFareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/addusercancellationfare";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD DRIVER CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function addDriverCancellationFareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adddrivercancellationfare";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateUserCancellationFareDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateusercancellationfare";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER WATING CHARGE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getUserWaitingCharge($user_id, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserwaitingcharge?user_id=" . $user_id . "&booking_type=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER NIGHT CHARGE FARE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getUserNightFare($user_id, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getusernightcharge?user_id=" . $user_id . "&id=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER NIGHT CRGE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserNightFareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/addusernightcharge";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER NIGHT FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateUserNightFareDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateusernightcharge";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER PREMIUMS FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserPremiumsFare($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserpremiumsfare?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER PREMIUM FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserPremiumFareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserpremiumsfare";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER PREMIUMS FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateUserPremiumFareDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateuserpremiumsfare";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER FIX ROUTE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserFixRoute($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserfixroute?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER FIX ROUTE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserFixRouteDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserfixroute";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER FIX ROUTE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateUserFixRouteDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateuserfixroute";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER POSTAL CODE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserPostalCode($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserpostalcode?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER POSTAL CODE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserPostalCodeDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserpostalcode";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER PEAK TIME FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserPeakTimeCharge($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserpeaktimecharge?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER PEAK TIME FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserPeakTimeChargeDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserpeaktimecharge";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER EXTRA FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserExtraCharge($user_id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserextras?user_id=" . $user_id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER EXTRA FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserExtraChargeDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserextras";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET USER PREWAITING CHARGE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserPreWaitingCharge($user_id, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getuserprewaitingcharge?user_id=" . $user_id . "&booking_type=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER WAITING FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserWaitingChargeDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserwaitingcharge";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER PRE WAITING FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserPreWaitingChargeDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/adduserprewaitingcharge";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER SHARE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserSharePrice($user_id, $id) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/getusercompanyshare?user_id=" . $user_id . "&id=" . $id;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER SHARE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function addUserShareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/fare_management/addusersharedetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER SHARE FARE DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateUserShareDetail($val) {
        $data = [];
        $url = $this->apiUrl() . "/fare_management/updateusersharedetail";
        $val = $this->post($url, $val);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER BOOKINGTYPE MAPPING DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getUserBookingTypeMappingDetail($data) {
        $url = $this->apiUrl() . "/user/getuserbookingtypemapping";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        $result = [];
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER BOOKING TYPE MAPPING STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateBookingTypeMappingStatus($data) {
        $url = $this->apiUrl() . "/user/bookingMappingStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD USER MAPPING DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addUserMappingDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/user/addbookingmappingdetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE USER MAPPING FARE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateUserMappingDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/user/updatebookingmappingdetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH CITY PAGE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getCityPageDetail($data) {
        $url = $this->apiUrl() . "/city-pages/getcityPages";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        $result = [];
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH FINANCIAL YEARS
     * @param $data
     * @returns $responsedata
     */

    public function financialYear() {
        $current_year = date('Y');
        $next_year = date('Y') + 1;
        $month = '04';
        $next_month = '03';
        $date = '01';
        $last_date = '31';

        $from_date = $date . '-' . $month . '-' . $current_year;
        $to_date = $last_date . '-' . $next_month . '-' . $next_year;
        return ['from_date' => $from_date, 'to_date' => $to_date];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET POINT CONVERSION DATA
     * @param $data
     * @returns $responsedata
     */

    public function getPointConversionDetail($data) {
        $url = $this->apiUrl() . "/wallet-point-conversion/getpointconversion";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        $result = [];
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET USER TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getUserTypeList($data = 'null') {
        $roleJsonDataArray = [];
        $val = '{"where": {"IsApproved": "1"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/user-role?&filter=" . $val;
        $resp = $this->get($url);
        $roleJsonData = Json::decode($resp->getBody(), true);
        foreach ($roleJsonData as $res) {
            if ($data != 'null' && is_array($data)) {
                if (in_array($res['Role_ID'], $data)) {
                    $roleJsonDataArray[$res['Role_ID']] = $res['RoleName'];
                }
            } else {
                $roleJsonDataArray[$res['Role_ID']] = $res['RoleName'];
            }
        }
        return $roleJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH USER TYPE GRADE
     * @param $data
     * @returns $responsedata
     */

    public function getUserTypeGradeList() {
        $gradeTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/user-grade";
        $resp = $this->get($url);
        $gradeTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($gradeTypeJsonData as $res) {
            $gradeTypeJsonDataArray[$res['id']] = $res['grade_name'];
        }
        return $gradeTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE POINT CONVERSION STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updatePointConversionStatus($data) {
        $url = $this->apiUrl() . "/wallet-point-conversion/pointconversionStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD POINT CONVERSION DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addPointConversionDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/wallet-point-conversion/addpointconversiondetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE POINT CONVERSION DETAILS
     * @returns $responsedata
     */

    public function updatePointConversionDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/wallet-point-conversion/updatepointconversiondetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO DELTE RECENTLY VIEWED ITEMS DETAIS
     * @param $data
     * @returns $responsedata
     */
    public function deleteRecentViewedItems($data) {
        $url = $this->apiUrl() . "/recently-viewed/deleterecentlyvieweddata";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD CITY PAGE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addCityPageDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/city-pages/addcitypagesdetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE CITY PAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateCityPageStatus($data) {
        $url = $this->apiUrl() . "/city-pages/cityPagesStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE CITY PAGE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateCityPageDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/city-pages/updatecitypagesdetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET CITY NAME BY ID
     * @param $data
     * @returns $responsedata
     */

    public function getCityName($id) {
        $val = '{"where": {"id": "' . $id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city?&filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data[0];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH SIGHTSEEING LISTING
     * @param $data
     * @returns $responsedata
     */

    public function getSightSeeingList($id) {
        $data = [];
        $url = $this->apiUrl() . "/sightseeing/getsightseeing?company_id=" . $id;
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        //echo '<pre>';print_r($jsonResponse);die();
        if ($jsonResponse['responsedata']['status'] == "success") {
            foreach ($jsonResponse['responsedata']['data'] as $key => $value) {
                $data[$value['s_id']] = $value['name'];
            }
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET MASTER PACKAGE ID
     * @param $data
     * @returns $responsedata
     */

    public function getMasterPackageId($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package?&filter=" . $val;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);
        $resp = [];
        if ($JsonData['status'] == 'success') {
            $resp = $JsonData['data'][0];
        }
        return $resp;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH ALL MEMBERSHIP FETAURES
     * @param $data
     * @returns $responsedata
     */

    public function getMembershipFeatures($data) {
        $url = $this->apiUrl() . "/membership_features/getMembershipFeatures";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        $result = [];
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE FETAURES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateFeaturesStatus($data) {
        $url = $this->apiUrl() . "/membership_features/updatemembershipFeaturesStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD MEMBERSHIP FEATURE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addMembershipFeature($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/membership_features/addmembershipFeaturesDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE MEMBERSHIP FEATURES DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateMembershipFeature($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/membership_features/updatemembershipFeaturesDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH TRANSPORT EVENT DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTransportEventsDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/vendor-status/getVendorStatusDetail";
        $resp = $this->post($url, $data);
        $vendorJsonData = Json::decode($resp->getBody(), true);
        if ($vendorJsonData['responsedata']['status'] == 'success') {
            $statusList = $vendorJsonData['responsedata']['data'];
            foreach ($statusList as $val) {
                $row['id'] = $val['id'];
                $row['title'] = $val['booking_ref_no'] . ' (' . $val['user_status'] . ')';
                //$row['start'] = date('Y-m-d',strtotime($val['start_date'])).' '.$val['started_time'];
                //$row['end'] = date('Y-m-d',strtotime($val['end_date'])).' '.$val['estimated_end_time'];
                $row['start'] = date('Y-m-d H:i:s', strtotime($val['start_date']));
                $row['end'] = date('Y-m-d H:i:s', strtotime($val['end_date']));
                $row['vendor_status'] = $val['vendor_status'];
                $row['allDay'] = false;
                if ($val['vendor_status'] == 1) {
                    $row['className'] = "info";
                } else {
                    $row['className'] = "important";
                }

                array_push($result, $row);
            }
        }
        return $result;
    }

   /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TRANSPORT EVENT DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTransportEventsStatus($data) {
        $url = $this->apiUrl() . "/vendor-status/updateVendorStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD TRANSPORT EVENT DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addTransportEventsDetails($data) {
        $url = $this->apiUrl() . "/vendor-status/addVendorStatusDetail"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TRANSPORT EVENT DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateTransportEventsDetails($data) {
        $url = $this->apiUrl() . "/vendor-status/updateVendorStatusDetail"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH LOCAL PACKAGE ID
     * @param $data
     * @returns $responsedata
     */

    public function getLocalPackageId($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"name": {"like": "' . $term . '%"}},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/local-package?&filter=" . $val;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);
        $resp = [];
        if (!empty($JsonData)) {
            $resp = $JsonData[0];
        }
        return $resp;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FIND PACKAGE MODE ID
     * @param $data
     * @returns $responsedata
     */

    public function findPackageModeId($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"package_mode": "' . $term . '"}}';
        // $val = '{"where": {"package_mode": {"'.$term.'"}}}';         
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package-mode?&filter=" . $val;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);

        $response = [];
        if (!empty($JsonData)) {
            $response = $JsonData[0];
        }
        return $response;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET CURRENCY ID
     * @param $data
     * @returns $responsedata
     */
    
    public function getCurrenyId($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"code": "' . $term . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/master-currency?&filter=" . $val;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);
        $response = [];
        if (!empty($JsonData)) {
            $response = $JsonData[0];
        }
        return $response;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH VEHICLE TYPE DATA
     * @param $data
     * @returns $responsedata
     */
    public function getVehicleTypeId($postdata) {
        $term = $postdata['term'];
        $val = '{"where": {"vehicle_type": "' . $term . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);
        $response = [];
        if ($JsonData['status'] == 'success') {
            $response = $JsonData['data'][0];
        }
        return $response;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD DISCOUNT HOUR FARE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addDistanceHourFare($dataArr) {
        $url = $this->apiUrl() . "/distance-hour-fare";
        $resp = $this->post($url, $dataArr);
        return $fareData = Json::decode($resp->getBody(), true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD PAYMENT STRUCTURE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addPaymentStructureDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-payment-structure/addPaymentStructureDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE PAYMENT STRUCTURE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updatePaymentStructureDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-payment-structure/updatePaymentStructureDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH PAYMENT STRUCTURES DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getPaymentStructureDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-payment-structure/getPaymentStructureDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET PAYMENT STRUCTURES DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getPaymentStructureList() {
        $data = [];
        $paymentStructureJsonDataArray = [];
        $url = $this->apiUrl() . "/master-payment-structure/getPaymentStructureDetails";
        $resp = $this->post($url, $data);
        $paymentStructureJsonData = Json::decode($resp->getBody(), true);
        if ($paymentStructureJsonData['responsedata']['status'] == "success") {
            foreach ($paymentStructureJsonData['responsedata']['data'] as $res) {
                $paymentStructureJsonDataArray[$res['id']] = $res['title'];
            }
        }
        return $paymentStructureJsonDataArray;
    }

   
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE PAYMENT STRUCTURES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updatePaymentStructureStatus($data) {
        $url = $this->apiUrl() . "/master-payment-structure/paymentStructureStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD DOCUMENTATION DETAILS DATA
     * @param $data
     * @returns $responsedata
     */

    public function addDocumentationDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-documentation/addDocumentationDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE DOCUMENTATION DETAILS DATA
     * @param $data
     * @returns $responsedata
     */

    public function updateDocumentationDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-documentation/updateDocumentationDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH DOCUMENTATION DETAILS DATA
     * @param $data
     * @returns $responsedata
     */

    public function getDocumentationDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-documentation/getDocumentationDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH DOCUMENTATION LIST
     * @param $data
     * @returns $responsedata
     */

    public function getDocumentationList() {
        $data = [];
        $paymentStructureJsonDataArray = [];
        $url = $this->apiUrl() . "/master-documentation/getDocumentationDetails";
        $resp = $this->post($url, $data);
        $paymentStructureJsonData = Json::decode($resp->getBody(), true);
        if ($paymentStructureJsonData['responsedata']['status'] == "success") {
            foreach ($paymentStructureJsonData['responsedata']['data'] as $res) {
                $paymentStructureJsonDataArray[$res['id']] = $res['title'];
            }
        }
        return $paymentStructureJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE DOCUMENTATION STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateDocumentationStatus($data) {
        $url = $this->apiUrl() . "/master-documentation/documentationStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH CANCELLATION POLICY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getCancellationPolicyDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-cancellation-policy/getCancellationPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD CANCELLATION POLICY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addCancellationPolicyDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-cancellation-policy/addCancellationPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE CANCELLATION POLICY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateCancellationPolicyDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-cancellation-policy/updateCancellationPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH CANCELLATION POLICY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getCancellationPolicyList() {
        $data = [];
        $cancelPolicyJsonDataArray = [];
        $url = $this->apiUrl() . "/master-cancellation-policy/getCancellationPolicyDetails";
        $resp = $this->post($url, $data);
        $cancelPolicyJsonData = Json::decode($resp->getBody(), true);
        if ($cancelPolicyJsonData['responsedata']['status'] == "success") {
            foreach ($cancelPolicyJsonData['responsedata']['data'] as $res) {
                $cancelPolicyJsonDataArray[$res['id']] = $res['title'];
            }
        }
        return $cancelPolicyJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE CANCELLATION POLICY STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateCancellationPolicyStatus($data) {
        $url = $this->apiUrl() . "/master-cancellation-policy/cancellationPolicyStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH REFUND POLICY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getRefundPolicyDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-refund-policy/getRefundPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH REFUND POLICY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getRefundPolicyList() {
        $data = [];
        $refundPolicyJsonDataArray = [];
        $url = $this->apiUrl() . "/master-refund-policy/getRefundPolicyDetails";
        $resp = $this->post($url, $data);
        $refundPolicyJsonData = Json::decode($resp->getBody(), true);
        if ($refundPolicyJsonData['responsedata']['status'] == "success") {
            foreach ($refundPolicyJsonData['responsedata']['data'] as $res) {
                $refundPolicyJsonDataArray[$res['id']] = $res['title'];
            }
        }
        return $refundPolicyJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD REFUND POLICY DETAILS DATA
     * @param $data
     * @returns $responsedata
     */

    public function addRefundPolicyDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-refund-policy/addRefundPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE REFUND POLICY DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateRefundPolicyDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-refund-policy/updateRefundPolicyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE REFUND POLICY STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateRefundPolicyStatus($data) {
        $url = $this->apiUrl() . "/master-refund-policy/refundPolicyStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH TERMS CONDITIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTermConditionsDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-terms-condition-policy/getTermConditionsDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET TERMS CONDITION POLICY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getTermConditionsPolicyList() {
        $data = [];
        $termPolicyJsonDataArray = [];
        $url = $this->apiUrl() . "/master-terms-condition-policy/getTermConditionsDetails";
        $resp = $this->post($url, $data);
        $termPolicyJsonData = Json::decode($resp->getBody(), true);
        if ($termPolicyJsonData['responsedata']['status'] == "success") {
            foreach ($termPolicyJsonData['responsedata']['data'] as $res) {
                $termPolicyJsonDataArray[$res['id']] = $res['title'];
            }
        }
        return $termPolicyJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD TERMS CONDITION DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addTermConditionsDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-terms-condition-policy/addTermConditionsDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TERMS CONDITION DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTermConditionsDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-terms-condition-policy/updateTermConditionsDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TERMS CONDDITIONS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTermConditionsStatus($data) {
        $url = $this->apiUrl() . "/master-terms-condition-policy/termConditionsPolicyStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET TOUR EXCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTourExclusionDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-tour-exclusion/getTourExclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD TOUR EXCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addTourExclusionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-tour-exclusion/addTourExclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TOUR EXCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateTourExclusionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-tour-exclusion/updateTourExclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TOUR EXCLUSION STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTourExclusionStatus($data) {
        $url = $this->apiUrl() . "/master-tour-exclusion/tourExclusionStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET TOUR INCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTourInclusionDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-tour-inclusion/getTourInclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD TOUR INCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addTourInclusionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-tour-inclusion/addTourInclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TOUR INCLUSIONS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateTourInclusionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-tour-inclusion/updateTourInclusionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TOUR INCLUSION STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTourInclusionStatus($data) {
        $url = $this->apiUrl() . "/master-tour-inclusion/tourInclusionStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH TRANSFERS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTransferDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-transfer/getTransferDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD TRANSFERS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addTransferDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-transfer/addTransferDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TRANSFERS DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateTransferDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-transfer/updateTransferDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TRANSFER STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateTransferStatus($data) {
        $url = $this->apiUrl() . "/master-transfer/transferStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO INSERT TOUR DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function insertTourDetails($data) {
        $url = $this->apiUrl() . "/tour-detail/addTourGeneralDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE TOUR AVAILABILITY OTHER DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateTourAvailabiltyOtherDetails($data) {
        $url = $this->apiUrl() . "/tour-detail/updateTourAvailabilityOthers";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET TOUR PACKAGE DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function getTourPackageDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/tour-detail/listTourDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET TOUR PACKAGE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getTourPackageList() {
        $data = [];
        $cancelPolicyJsonDataArray = [];
        $url = $this->apiUrl() . "/tour-detail/getTourDetails";
        $resp = $this->post($url, $data);
        $cancelPolicyJsonData = Json::decode($resp->getBody(), true);
        if ($cancelPolicyJsonData['responsedata']['status'] == "success") {
            foreach ($cancelPolicyJsonData['responsedata']['data'] as $res) {
                $cancelPolicyJsonDataArray[$res['id']] = $res['tours_name'];
            }
        }
        return $cancelPolicyJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE CITY INTRODUCTION LIST
     * @param $data
     * @returns $responsedata
     */

    public function getCityIntroductionDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-city-introduction/getCityIntroductionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD CITY INTRODUCTION DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function addCityIntroductionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-city-introduction/addCityIntroductionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE CITY INTRODUCTION DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateCityIntroductionDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/master-city-introduction/updateCityIntroductionDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE CITY INTRODUCTION STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateCityIntroductionStatus($data) {
        $url = $this->apiUrl() . "/master-city-introduction/cityIntroductionStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH ROOM CATEGORY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getRoomCategoryList() {
        $data = [];
        $roomTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-room-category/getRoomCategoryDetails";
        $resp = $this->post($url, $data);
        $roomTypeJsonData = Json::decode($resp->getBody(), true);
        if ($roomTypeJsonData['responsedata']['status'] == "success") {
            foreach ($roomTypeJsonData['responsedata']['data'] as $res) {
                $roomTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $roomTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE MEAL PLAN TYPE LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getMealPlanTypeList() {
        $data = [];
        $mealPlanTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-meal-plan-type/getMealPlanTypeDetails";
        $resp = $this->post($url, $data);
        $mealPlanTypeJsonData = Json::decode($resp->getBody(), true);
        if ($mealPlanTypeJsonData['responsedata']['status'] == "success") {
            foreach ($mealPlanTypeJsonData['responsedata']['data'] as $res) {
                $mealPlanTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $mealPlanTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE PROPERTY TYPE LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getPropertyTypeList() {
        $data = [];
        $propertyTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-property-type/getPropertyTypeDetails";
        $resp = $this->post($url, $data);
        $propertyTypeJsonData = Json::decode($resp->getBody(), true);
        if ($propertyTypeJsonData['responsedata']['status'] == "success") {
            foreach ($propertyTypeJsonData['responsedata']['data'] as $res) {
                $propertyTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $propertyTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE HOTEL CATEGORY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getHotelCategoryList() {
        $data = [];
        $mealPlanTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-category/getHotelCategoryDetails";
        $resp = $this->post($url, $data);
        $mealPlanTypeJsonData = Json::decode($resp->getBody(), true);
        if ($mealPlanTypeJsonData['responsedata']['status'] == "success") {
            foreach ($mealPlanTypeJsonData['responsedata']['data'] as $res) {
                $mealPlanTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $mealPlanTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO INSERT THE HOTEL DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function insertHotelDetails($data) {
        $url = $this->apiUrl() . "/hotel-detail/addHotelGeneralDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH HOTEL DETAILS LIST
     * @param $data
     * @returns $responsedata
     */

    public function getHotelDetailsList($data) {
        $result = [];
        $url = $this->apiUrl() . "/hotel-detail/listHotelDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE HOTEL STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateHotelStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelDetailStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE HOTEL DETAILS
     * @param $data
     * @returns $responsedata
     */

    public function updateHotelDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/updateHotelDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE LOGIN STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateLoginStatus($data) {
        $url = $this->apiUrl() . "/user/loginStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    ///////// CODE DONE BY MOHIT JAIN  ////////////////////

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-Oct-2020
     * @description : HOTEL List
     * @param $data
     * @returns $hotelJsonDataArray
     */
    public function getHotelList($data) {
        $hotelJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelList";
        $resp = $this->post($url, $data);
        $hotelJsonData = Json::decode($resp->getBody(), true);
        if (count($hotelJsonData['responsedata']['data']) > 0) {
            foreach ($hotelJsonData['responsedata']['data'] as $res) {
                $hotelJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $hotelJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-Oct-2020
     * @description : UPDATE HOTEL CONTACT INFORMATION TAB
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelContactDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/updateHotelContactDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 03-Oct-2020
     * @description : UPDATE HOTEL ALLOCATION INFORMATION TAB
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelAllocationDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/updateHotelAllocationDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-Oct-2020
     * @description : UPDATE HOTEL CONTACT INFORMATION TAB
     * @param $data
     * @returns $responsedata
     */
    public function getHotelDetails($data) {
        $result = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        //echo "<pre>";print_r($responsedata); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 06-Oct-2020
     * @description : GET HOTEL FACILITY DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function getHotelFeaturesList($data) {
        $featureJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelFeaturesList";
        $resp = $this->post($url, $data);
        $featureJsonData = Json::decode($resp->getBody(), true);
        //echo "<pre>"; print_r($featureJsonData); die;
        if ($featureJsonData['responsedata']['status'] == "success") {
            foreach ($featureJsonData['responsedata']['data'] as $res) {
                $featureJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $featureJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 06-Oct-2020
     * @description : GET CURRENCY LIST
     * @param $data
     * @returns $responsedata
     */
    public function getCurrencyList() {
        $currencyTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-currency";
        $resp = $this->get($url);
        $currencyTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($currencyTypeJsonData as $res) {
            $currencyTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $currencyTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-Oct-2020
     * @description : GET PAYMENT TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getPaymentTypeList() {
        $paymentTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/payment-type";
        $resp = $this->get($url);
        $paymentTypeJsonData = Json::decode($resp->getBody(), true);
        if ($paymentTypeJsonData['status'] == "success") {
            foreach ($paymentTypeJsonData['data'] as $res) {
                $paymentTypeJsonDataArray[$res['payment_type_id']] = $res['pay_type_mode'];
            }
        }
        return $paymentTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-Oct-2020
     * @description : UPDATE HOTEL PAYMENT FEATURE INFORMATION TAB
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelPaymentFeatureDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/addHotelPaymentFeatureDetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        echo "<pre>";print_r($JsonData); die;
        $responsedata = Json::decode($JsonData, true);
        //echo "<pre>";print_r($responsedata); die;
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 09-Oct-2020
     * @description : FETCH HOTEL FACILITIES
     * @param $data
     * @returns $responsedata
     */
    public function getHotelFacilityList($data) {
        $facilityJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelFacilityList";
        $resp = $this->post($url, $data);
        $facilityJsonData = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($facilityJsonData['responsedata']['status'] == "success") {
            foreach ($facilityJsonData['responsedata']['data'] as $res) {
                $facilityJsonDataArray[$res['id']] = $res['facility_name_id'];
            }
        }
        return $facilityJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 09-Oct-2020
     * @description : FETCH HOTEL SPORTS RECREATIONS
     * @param $data
     * @returns $responsedata
     */
    public function getHotelSportsRecreationList($data) {
        $sportsJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelSportsRecreationList";
        $resp = $this->post($url, $data);
        $sportsJsonData = Json::decode($resp->getBody(), true);
        if ($sportsJsonData['responsedata']['status'] == "success") {
            foreach ($sportsJsonData['responsedata']['data'] as $res) {
                $sportsJsonDataArray[$res['id']] = $res['sports_recreation_id'];
            }
        }
        return $sportsJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 09-Oct-2020
     * @description : FETCH HOTEL EXTRA INFO
     * @param $data
     * @returns $responsedata
     */
    public function getHotelExtraInfoList($data) {
        $extraInfoJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelExtraInfoList";
        $resp = $this->post($url, $data);
        $extraInfoJsonData = Json::decode($resp->getBody(), true);
        if ($extraInfoJsonData['responsedata']['status'] == "success") {
            foreach ($extraInfoJsonData['responsedata']['data'] as $res) {
                $extraInfoJsonDataArray[$res['id']] = $res['extra_info_id'];
            }
        }
        return $extraInfoJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 09-Oct-2020
     * @description : FETCH HOTEL PAYMENT OPTION
     * @param $data
     * @returns $responsedata
     */
    public function getHotelPaymentOptionList($data) {
        $paymentOptionJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelPaymentOptionList";
        $resp = $this->post($url, $data);
        $paymentOptionJsonData = Json::decode($resp->getBody(), true);
        if ($paymentOptionJsonData['responsedata']['status'] == "success") {
            foreach ($paymentOptionJsonData['responsedata']['data'] as $res) {
                $paymentOptionJsonDataArray[$res['id']] = $res['payment_option_id'];
            }
        }
        return $paymentOptionJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 13-Oct-2020
     * @description : FETCH HOTEL ROOM TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getRoomTypeList() {
        $data = [];
        $roomTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-room-type/getRoomTypeDetails";
        $resp = $this->post($url, $data);
        $roomTypeJsonData = Json::decode($resp->getBody(), true);
        if ($roomTypeJsonData['responsedata']['status'] == "success") {
            foreach ($roomTypeJsonData['responsedata']['data'] as $res) {
                $roomTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $roomTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 13-Oct-2020
     * @description : FETCH HOTEL ROOM FACILITY LIST
     * @param $data
     * @returns $responsedata
     */
    public function getRoomFacilityList() {
        $data = [];
        $roomTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-room-facility/getRoomFacilityDetails";
        $resp = $this->post($url, $data);
        $roomTypeJsonData = Json::decode($resp->getBody(), true);
        if ($roomTypeJsonData['responsedata']['status'] == "success") {
            foreach ($roomTypeJsonData['responsedata']['data'] as $res) {
                $roomTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $roomTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-Oct-2020
     * @description : INSERT HOTEL ROOM DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function insertHotelRoomDetails($data) {
        $url = $this->apiUrl() . "/hotel-detail/addHotelRoomDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-Oct-2020
     * @description : GET HOTEL ROOM DETAILS LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomDetailsList($data) {
        $result = [];
        $url = $this->apiUrl() . "/hotel-detail/listHotelRoomDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    public function getMealPlanListData($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-hotel-meal-plan-type/getHotelMealPlanTypeDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-Mar-2021
     * @description : FETCH HOTEL ROOM LIST BY HOTEL ID
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomList($data) {
        $roomJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/listHotelRoomDetails";
        $resp = $this->post($url, $data);
        $roomJsonData = Json::decode($resp->getBody(), true);
        //print_r($roomJsonData); die;
        if ($roomJsonData['responsedata']['status'] == "success") {
            foreach ($roomJsonData['responsedata']['data'] as $res) {
                $roomName = $res['name'] . ' (' . $res['room_category_name'] . ')';
                $roomJsonDataArray[$res['id']] = $roomName;
            }
        }
        //print_r($roomJsonDataArray);die;
        return $roomJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 16-Oct-2020
     * @description : FETCH HOTEL ROOM FACILITIES
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomFacilityList($data) {
        $facilityJsonDataArray = [];
        $url = $this->apiUrl() . "/hotel-detail/getHotelRoomFacilityList";
        $resp = $this->post($url, $data);
        $facilityJsonData = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($facilityJsonData['responsedata']['status'] == "success") {
            foreach ($facilityJsonData['responsedata']['data'] as $res) {
                $facilityJsonDataArray[$res['id']] = $res['facility_type_id'];
            }
        }
        return $facilityJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 16-Oct-2020
     * @description : UPDATE HOTEL ROOM DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelRoomDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/updateHotelRoomDetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 17-Oct-2020
     * @description : UPDATE HOTEL ROOM STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelRoomStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelRoomDetailStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     *
     * @return Country
     */
    public function getStateCountry($city_id) {
        $data = [];
        if ($city_id) {
            $url = $this->apiUrl() . "/city/stateCountry?city_id=" . $city_id;
            $resp = $this->get($url);
            $data = Json::decode($resp->getBody(), true);
            $data = $data['response'][0];
        }
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 28-March-2021
     * @description : UPDATE HOTEL BROUCHER META TAG
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelMetaDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/updateHotelMetaDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-April-2021
     * @description : UPDATE HOTEL TERMS POLICY 
     * @param $data
     * @returns $responsedata
     */
    public function updateTermsPolicyDetails($data) {
        $url = $this->apiUrl() . "/hotel-detail/updateHotelTermsPolicy";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 08-April-2021
     * @description : GET HOTEL VENDOR TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelVendorTypeList($data) {
        $roleJsonDataArray = [];
        $url = $this->apiUrl() . "/user-role-vendor/getHotelVendorRoleList";
        $resp = $this->post($url, $data);
        $roleJsonData = Json::decode($resp->getBody(), true);
        if ($roleJsonData['responsedata']['status'] == "success") {
            foreach ($roleJsonData['responsedata']['data'] as $res) {
                $roleJsonDataArray[$res['user_role_id']] = $res['user_role_name'];
            }
        }
        return $roleJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 08-April-2021
     * @description : GET HOTEL VENDOR LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelVendorListData($data) {
        $roleJsonDataArray = [];
        $url = $this->apiUrl() . "/user-role-vendor/getHotelUserList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        //var_dump($responsedata); die;
        if ($responsedata['responsedata']['status'] == "success") {
            foreach ($responsedata['responsedata']['data'] as $res) {
                $userName = $res['username'] . ' (' . $res['mobile_no'] . ')';
                $roleJsonDataArray[$res['id']] = $userName;
            }
        }
        return $roleJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 08-April-2021
     * @description : GET HOTEL VENDOR LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelVendorList($data) {
        $result = [];
        $url = $this->apiUrl() . "/user-role-vendor/getHotelUserList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 27-July-2021
     * @description : GET HOTEL RATE TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRateTypeListData($data) {
        $result = [];
        $url = $this->apiUrl() . "/master-hotel-rate-type/getHotelRateTypeDetails";
        $resp = $this->post($url, $data);
        $rateTypeJsonData = Json::decode($resp->getBody(), true);
        if ($rateTypeJsonData['responsedata']['status'] == "success") {
            $result = $rateTypeJsonData['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 08-April-2021
     * @description : GET HOTEL RATE TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRateTypeList($data) {
        $hotelRateTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-rate-type/getHotelRateTypeDetails";
        $resp = $this->post($url, $data);
        $rateTypeJsonData = Json::decode($resp->getBody(), true);
        if ($rateTypeJsonData['responsedata']['status'] == "success") {
            foreach ($rateTypeJsonData['responsedata']['data'] as $res) {
                $hotelRateTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $hotelRateTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-April-2021
     * @description : GET HOTEL RATE NAME LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRateNameList($data = '') {
        $hotelRateNameJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-rate-name/getHotelRateNameDetails";
        $resp = $this->post($url, $data);
        $rateNameJsonData = Json::decode($resp->getBody(), true);
        if ($rateNameJsonData['responsedata']['status'] == "success") {
            foreach ($rateNameJsonData['responsedata']['data'] as $res) {
                $hotelRateNameJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $hotelRateNameJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-April-2021
     * @description : GET HOTEL SEASON NAME LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelSeasonNameList($data) {
        $hotelSeasonJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-season/getHotelSeasonDetails";
        $resp = $this->post($url, $data);
        $seasonJsonData = Json::decode($resp->getBody(), true);
        if ($seasonJsonData['responsedata']['status'] == "success") {
            foreach ($seasonJsonData['responsedata']['data'] as $res) {
                $hotelSeasonJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $hotelSeasonJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-April-2021
     * @description : GET HOTEL PROMOTION RATE TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getPromotionRateTypeList($data) {
        $promotionRateTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-promotion-type/getHotelPromotionTypeDetails";
        $resp = $this->post($url, $data);
        $hotelPromotionTypeJsonData = Json::decode($resp->getBody(), true);
        if ($hotelPromotionTypeJsonData['responsedata']['status'] == "success") {
            foreach ($hotelPromotionTypeJsonData['responsedata']['data'] as $res) {
                $promotionRateTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $promotionRateTypeJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 14-April-2021
     * @description : GET HOTEL MEAL PLAN TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getMealPlanList($data) {
        $hotelMealPlanTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-hotel-meal-plan-type/getHotelMealPlanTypeDetails";
        $resp = $this->post($url, $data);
        $mealPlanTypeJsonData = Json::decode($resp->getBody(), true);
        if($mealPlanTypeJsonData['responsedata']['status']=="success"){
            foreach($mealPlanTypeJsonData['responsedata']['data'] as $res){
                $hotelMealPlanTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $hotelMealPlanTypeJsonDataArray;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 20-April-2020
     * @description : INSERT HOTEL ROOM RATE DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function insertHotelRoomRateDetails($data) {
        $url = $this->apiUrl() . "/room-rate/addHotelRoomRateDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 20-April-2020
     * @description : INSERT HOTEL ROOM RATE DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelRoomRateDetails($data) {
        $url = $this->apiUrl() . "/room-rate/updateHotelRoomRateDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 20-April-2020
     * @description : GET MEAL PLAN TYE NAME
     * @param $data
     * @returns $responsedata
     */
    public function getMealPlanTypeName($id) {
        $url = $this->apiUrl() . "/master-meal-plan-type/".$id;
        $val = $this->get($url);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);        
        return strtolower(str_replace(' ', '', $jsonResponse['name']));
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 06-jULY-2021
     * @description : GET HOTEL ROOM RATE DETAILS LIST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomRateDetailsList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/listHotelRoomRateDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 06-July-2021
     * @description : FETCH HOTEL EXTRA MEAL COST
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomRateExtraMealList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getHotelRoomRateExtraMealList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 06-July-2021
     * @description : FETCH HOTEL ROOM RATE DATA
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomRateDataList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getHotelRoomRateDataList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($responsedata); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE STAY MORE DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getStayMoreDiscountList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getStayMoreDiscountList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($responsedata); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE LAST MINUTE DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getLastMinuteDiscountList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getLastMinuteDiscountList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE EARLY DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getEarlyDiscountList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getEarlyDiscountList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE DAY WISE DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getDayWiseDiscountList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getDayWiseDiscountList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE DAY WISE DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getSeasonDiscountList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getSeasonDiscountList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM MEAL DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getMealList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getMealList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM MEAL DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getWeekDaysList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getWeekDaysList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ACTIVITY FARE
     * @param $data
     * @returns $responsedata
     */
    public function getActivityFareList($data) {
        $result = [];
        $url = $this->apiUrl() . "/sightseeing/getActivityFareList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 07-July-2021
     * @description : FETCH ROOM RATE DAY WISE DISCOUNT DATA
     * @param $data
     * @returns $responsedata
     */
    public function getHotelFreeOffersList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getHotelFreeOffersList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        //print_r($facilityJsonData); die;
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sept-2021
     * @description : FETCH SIGHTSEEING DETAILS 
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingDetailsList($data) {       
        $result = [];
        $url = $this->apiUrl() . "/sightseeing/listsightseeing";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-Oct-2021
     * @description : FETCH SIGHTSEEING DETAILS LIST
     * @param $data
     * @returns $responsedata
     */
    public function getActivityDetailsList($data) {       
        $result = [];
        $url = $this->apiUrl() . "/sightseeing/getActivityDetailsList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
        
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sept-2021
     * @description : UPDATE SIGHTSEEING STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateSightseeingStatus($data) {
        $url = $this->apiUrl() . "/sightseeing/SightseeingDetailStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : FETCH Sightseeing Languages LIST
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingLanguagesList($data) {
        $langJsonDataArray = [];
        $url = $this->apiUrl() . "/sightseeing/getSightseeingLanguagesList";
        $resp = $this->post($url, $data);
        $langJsonData = Json::decode($resp->getBody(), true);
        //print_r($categoryJsonData); die;
        if ($langJsonData['responsedata']['status'] == "success") {
            foreach ($langJsonData['responsedata']['data'] as $res) {
                $langJsonDataArray[$res['id']] = $res['language_id'];
            }
        }
        return $langJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : FETCH Sightseeing Category LIST
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingCategoryList($data) {
        $categoryJsonDataArray = [];
        $url = $this->apiUrl() . "/sightseeing/getSightseeingCategoryList";
        $resp = $this->post($url, $data);
        $categoryJsonData = Json::decode($resp->getBody(), true);
        //print_r($categoryJsonData); die;
        if ($categoryJsonData['responsedata']['status'] == "success") {
            foreach ($categoryJsonData['responsedata']['data'] as $res) {
                $categoryJsonDataArray[$res['id']] = $res['category_id'];
            }
        }
        return $categoryJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : FETCH Sightseeing TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingTypeList($data) {
        $typeJsonDataArray = [];
        $url = $this->apiUrl() . "/sightseeing/getSightseeingTypeList";
        $resp = $this->post($url, $data);
        $typeJsonData = Json::decode($resp->getBody(), true);
        //print_r($categoryJsonData); die;
        if ($typeJsonData['responsedata']['status'] == "success") {
            foreach ($typeJsonData['responsedata']['data'] as $res) {
                $typeJsonDataArray[$res['id']] = $res['sightseeing_type_id'];
            }
        }
        return $typeJsonDataArray;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : FETCH Sightseeing SEASON LIST
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingSeasonList($data) {
        $seasonJsonDataArray = [];
        $url = $this->apiUrl() . "/sightseeing/getSightseeingSeasonList";
        $resp = $this->post($url, $data);
        $seasonJsonData = Json::decode($resp->getBody(), true);
        //print_r($categoryJsonData); die;
        if ($seasonJsonData['responsedata']['status'] == "success") {
            foreach ($seasonJsonData['responsedata']['data'] as $res) {
                $seasonJsonDataArray[$res['id']] = $res['season_type_id'];
            }
        }
        return $seasonJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : FETCH Sightseeing Things LIST
     * @param $data
     * @returns $responsedata
     */
    public function getSightseeingThingsList($data) {
        $thingsJsonDataArray = [];
        $url = $this->apiUrl() . "/sightseeing/getSightseeingThingsList";
        $resp = $this->post($url, $data);
        $thingsJsonData = Json::decode($resp->getBody(), true);
        //print_r($categoryJsonData); die;
        if ($thingsJsonData['responsedata']['status'] == "success") {
            foreach ($thingsJsonData['responsedata']['data'] as $res) {
                $thingsJsonDataArray[$res['id']] = $res['things_carry_id'];
            }
        }
        return $thingsJsonDataArray;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sep-2021
     * @description : UPDATE SIGHTSEEING GENERAL DETAILS
     * @param $data
     * @returns $responsedata
     */
    public function updateSighseetingDetails($data) {
        //var_dump($data); die;
        $responsedata = [];
        $url = $this->apiUrl() . "/sightseeing/updateSightseeingGeneralDetail";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-Sept-2021
     * @description : UPDATE SIGHTSEEING BROUCHER META TAG
     * @param $data
     * @returns $responsedata
     */
    public function updateSightseeingMetaDetails($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/sightseeing/updateSightseeingMetaInfo";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-Sept-2021
     * @description : UPDATE SIGHTSEEING BROUCHER META TAG
     * @param $data
     * @returns $responsedata
     */
    public function updateSightseeingTermsPolicyDetails($data) {
        $url = $this->apiUrl() . "/sightseeing/updateSightseeingTermCondition";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 10-Oct-2021
     * @description : UPDATE SIGHTSEEING DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateSightseeingRateStatus($data) {
        $url = $this->apiUrl() . "/sightseeing/SightseeingRateStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-Sept-2021
     * @description : FETCH SIGHTSEEING DETAILS 
     * @param $data
     * @returns $responsedata
     */
    public function getActivityList($data) {       
        $result = [];
        $url = $this->apiUrl() . "/sightseeing/getActivityList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function uploadImage($data) {
        $url = $this->apiUrl() . "/hotel-detail/uploadImage";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : GET UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function getUploadImages($data)
    {
        $result = [];
        $url = $this->apiUrl() . "/hotel-detail/getUploadImagesList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : GET UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function updateImageStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelImageStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : GET UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function updateActivityImageStatus($data) {
        $url = $this->apiUrl() . "/sightseeing/SightseeingImageStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPDATE IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function resetDefaultImageStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/imageUnsetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPDATE IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function resetActivityDefaultImageStatus($data) {
        $url = $this->apiUrl() . "/sightseeing/imageUnsetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPDATE IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateImageDefaultStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/imageSetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPDATE IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateActivityImageDefaultStatus($data) {
        $url = $this->apiUrl() . "/sightseeing/imageSetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : GET UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function getActivityUploadImages($data)
    {
        $result = [];
        $url = $this->apiUrl() . "/sightseeing/getUploadImagesList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function uploadActivityImage($data) {
        $url = $this->apiUrl() . "/sightseeing/uploadImage";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-October-2021
     * @description : UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function uploadHotelImage($data) {
        $url = $this->apiUrl() . "/hotel-detail/uploadImage";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-November-2021
     * @description : UPLOAD ROOM IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function uploadHotelRoomImage($data) {
        $url = $this->apiUrl() . "/hotel-detail/uploadRoomImage";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-November-2021
     * @description : GET UPLOAD HOTEL ROOM IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function getHotelRoomUploadImages($data)
    {
        $result = [];
        $url = $this->apiUrl() . "/hotel-detail/getUploadHotelRoomImagesList";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-November-2021
     * @description : GET UPLOAD IMAGES
     * @param $data
     * @returns $responsedata
     */
    public function updateRoomImageStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelRoomImageStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-November-2021
     * @description : UPDATE ROOM IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function resetRoomDefaultImageStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/imageRoomUnsetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 25-November-2021
     * @description : UPDATE ROOM IMAGE STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateRoomImageDefaultStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/imageRoomSetDefaultStatus"; //die;
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : UPDATE HOTEL PREFERRED STATUS
     * @param $data
     * @returns $responsedata
     */
    public function updateHotelPreferredStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelPreferredStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : GET VENDOR HOTEL DETAILS
     * @param $data
     * @returns $responsedata
     */    
    public function getHotelDataById($data) {
        $url = $this->apiUrl() . "/hotel-detail/getHotelDataById";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }    
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT VENDOR HOTEL DETAILS
     * @param $data
     * @returns $responsedata
     */    
    public function insertVendorHotelDetails($data) {
        $url = $this->apiUrl() . "/hotel-detail/addHotelVendorDetail";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT VENDOR HOTEL MAPPING DETAILS
     * @param $data
     * @returns $responsedata
     */    
    public function insertHotelVendorMapping($data) {
        $url = $this->apiUrl() . "/hotel-detail/addHotelVendorMapping";
        $val = $this->post($url, $data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        return $jsonResponse;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT HOTEL CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */   
    public function addHotelCancellationFareDetail($data) {
        $responsedata = [];
        $url = $this->apiUrl() . "/hotel-detail/addhotelcancellationfare";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        return $responsedata;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT HOTEL CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */       
    public function getHotelCancellationFare($dataCancel) {
        $data = [];
        $url = $this->apiUrl() . "/hotel-detail/gethotelcancellationfare";
        $val = $this->post($url, $dataCancel);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $data = $responsedata['responsedata']['data'];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT HOTEL CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */   
    public function getMasterCancellationTypeList($val) {
        $data = [];
        $cancelTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/cancellation-list/getCancellationDetails";
        $resp = $this->post($url, $val);
        $cancelTypeJsonData = Json::decode($resp->getBody(), true);
        if ($cancelTypeJsonData['responsedata']['status'] == "success") {
            foreach ($cancelTypeJsonData['responsedata']['data'] as $res) {
                $cancelTypeJsonDataArray[$res['id']] = $res['name'];
            }
        }
        return $cancelTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 12-December-2021
     * @description : INSERT HOTEL CANCELLATION FARE DETAILS
     * @param $data
     * @returns $responsedata
     */   
    public function updateHotelCancelFeesStatus($data) {
        $url = $this->apiUrl() . "/hotel-detail/hotelCancelFeesStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 26-December-2021
     * @description : FETCH ROOM RATE COMMISSIONABLE FARE
     * @param $data
     * @returns $responsedata
     */
    public function getRoomRateCommissionFareList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getRoomCommissionFareList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 27-December-2021
     * @description : FETCH SERVICE CHARGE ROOM RATE FARE
     * @param $data
     * @returns $responsedata
     */
    public function getRoomServiceChargeFareList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getRoomServiceChargeFareList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 28-December-2021
     * @description : FETCH BASIC ROOM RATE TAX DATA
     * @param $data
     * @returns $responsedata
     */
    public function getHotelBasicTax($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getHotelBasicTax";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 15-April-2022
     * @description : FETCH THE DISCOUNT RATE
     * @param $data
     * @returns $responsedata
     */
    public function getRoomRateDiscountFareList($data) {
        $result = [];
        $url = $this->apiUrl() . "/room-rate/getRoomDiscountFareList";
        $resp = $this->post($url, $data);
        $responsedata = Json::decode($resp->getBody(), true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE COMPANY DETAILS LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getCompanyDetailsList($data) {
        $result = [];
        $url = $this->apiUrl() . "/company-setup/getCompanyDetails";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responsedata = Json::decode($JsonData, true);
        if ($responsedata['responsedata']['status'] == "success") {
            $result = $responsedata['responsedata']['data'];
        }
        return $result;
    }

}