<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Model;
use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Booking extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

     //Get distance fare detail by base_vehicle_id //
    function getDistanceFare() {
        $arrdata  = ['message'=>'hello'];
        return $arrdata;
    }
    // End//

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE CREDIT BALANCE
     * @param $data
     * @returns $responsedata
     */
    
    public function getCreditBalance($data) {
        $url = $this->apiUrl() . "/user-management/userCreditLimit";
        $resp = $this->get($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE RECENT BOOKINGS
     * @param $data
     * @returns $responsedata
     */
    
    public function getRecentBookings($data) {
        $url = $this->apiUrl() . "/booking/bookingList";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        $result = [];
        if($data['responsedata']['status']=='success'){
           $result  = $data['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE WALLET POINTS
     * @param $data
     * @returns $responsedata
     */
    
    public function getWalletPoint($data) {
        if($data['id']>0){
        $url = $this->apiUrl() . "/user-management/userWalletHistory?id=".$data['id'];
        }else{
        $url = $this->apiUrl() . "/user-management/userWalletHistory";
        }
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE RECENTLY CANCELLED BOOKINGS
     * @param $data
     * @returns $responsedata
     */
    
    public function getCancelBookings($data) {
        $url = $this->apiUrl() . "/booking/bookingList";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        $result = [];
        if($responsedata['responsedata']['status']=='success'){
           $result  = $responsedata['responsedata']['data'];
        }
        return $result;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE BOOKING COUNTS
     * @param $data
     * @returns $responsedata
     */
    
    public function getBookingCounts($data) {
        $url = $this->apiUrl() . "/booking/getBookingCount";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        $result = [];
        if($responsedata['responsedata']['status']=='success'){
           $result  = $responsedata['responsedata']['data'];
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE VEHICLE TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getVehicleTypeList($data = null) {
        $vehicleTypeJsonData = [];
        $val = '{"where": {"status": {"neq": 2}}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        $resp = $this->get($url);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        return $vehicleTypeJsonData['data'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE EXECUTE NO SHOW LIST
     * @param $data
     * @returns $responsedata
     */

    public function getExecuteNoShow($data) {
        $url = $this->apiUrl() . "/booking/executeNoShow";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        return $responsedata['responsedata'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE REDISPATCH LIST
     * @param $data
     * @returns $responsedata
     */

    public function getRedispatch($data) {
        $url = $this->apiUrl() . "/booking/reDispatch";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        return $responsedata['responsedata'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GENERATE THE BILL
     * @param $data
     * @returns $responsedata
     */

    public function generateBill($data) {
        $url = $this->apiUrl() . "/driver/cabBillingComplete";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($responsedata);die();
        return $responsedata['responsedata'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE ACTIVE DRIVER LIST
     * @param $data
     * @returns $responsedata
     */

    public function getActiveDriverList($userid) {
        $param='/';
        if($userid >0){
            $param = "?userid=".$userid ;
        }
        $url = $this->apiUrl() . "/driver/getDriverList".$param;
        $resp = $this->get($url);
        $responsedata = Json::decode($resp->getBody(), true);
        $result = [];
        if($responsedata!=""){
        if($responsedata['responsedata']['status']=='success'){
           $result  = $responsedata['responsedata']['data'];
        }
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE WALLET AMOUNT DATA
     * @param $data
     * @returns $responsedata
     */

    public function getWalletAmt($user_id) {
        $url = $this->apiUrl() . "/user/walletamount?user_id=" . $user_id;
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        $walletAmt = $response['responsedata']['data']['wallet_amount'];
        if ($walletAmt != "") {
            $data = $response['responsedata']['data']['wallet_amount'];
        } else {
            $data = 0;
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET PAYMENT UPLOAD HISTORY DATA
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserpaymentUploadHistory($user_id,$userTypeId){
        $url = $this->apiUrl() . "/user/userCreditHistory?user_id=" . $user_id;
        if($userTypeId==10){
            $url = $this->apiUrl() . "/user/allUserCreditBalance?";
        }       
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        $responseData = $response['responsedata']['status'];
        if ($responseData == "success") {
            $data = $response['responsedata']['data'];
        } else {
            $data = [];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET USER UPLOAD CREDIT BALANCE
     * @param $data
     * @returns $responsedata
     */
    
     public function getUserUploadCreditBalance($user_id){       
        $url = $this->apiUrl() . "/user/userUploadCreditBalance?user_id=" . $user_id;  
        $resp = $this->get($url);
        $response = Json::decode($resp->getBody(), true);
        $responseData = $response['responsedata']['status'];        
        if ($responseData == "success") {
            $data = $response['responsedata']['data'];           
        } else {
            $data = [];
        }
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE AUTO RELEASE DATE
     * @param $data
     * @returns $responsedata
     */
    
    public function updateAutoReleaseDate($data) {
        $url = $this->apiUrl() . "/booking/updateBookingAutoReleaseDate";
        $resp = $this->post($url,$data);
        $responsedata = Json::decode($resp->getBody(), true);
        return $responsedata['responsedata'];
    }
}