<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Date,
    Text,
    Radio,
    Checkbox,
    Email,
    Textarea,
    Submit,
    Hidden
};

class VehicleDetailSearchForm extends Form {

    public static $cab_type = [];
    public static $modelYear = [];

    public function __construct($name = null) {

        parent::__construct('vehicle-detail-search-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Vehicle Name
         */
        $this->add([
            'name' => 'vehicle_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-name',
                'placeholder' => 'Vehicle Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vehicle Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle Model
         */
        $this->add([
            'name' => 'model_year',
            'type' => Select::class,
            'attributes' => [
                'id' => 'model-year',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Model Year',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$modelYear,
                'empty_option' => 'Select'
            ],
        ]);
        /**
         * Driver Name
         */
        $this->add([
            'name' => 'driver_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-name',
                'placeholder' => 'Driver Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-name',
                'placeholder' => 'City',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'City',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle Number
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => 'DL-0000',
                'class' => 'form-control inputchange',
                'maxlength'=>60,

            ],
            'options' => [
                'label' => 'Vehicle Number',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Cab Type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle Type',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$cab_type,
                'empty_option' => 'Select'
            ],
        ]);

        /**
         *
         * State
         */
        $this->add([
            'name' => 'state_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'state-name',
                'placeholder' => 'State',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'State',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-red btn-warning reset_btn'
            ],
        ]);

        /**
         * State Value
         */
        $this->add([
            'name' => 'state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'state-value'
            ],
        ]);

        /**
         * City Value
         */
        $this->add([
            'name' => 'city_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'city-value'
            ],
        ]);

        /**
         * Vehicle Model Id
         */
        $this->add([
            'name' => 'vehicle_model_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle-model-id'
            ],
        ]);
    }

}
