<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Date,
    Text,
    Radio,
    Checkbox,
    Email,
    Textarea,
    Submit,
    Hidden
};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;


class VehicleDetailMappingForm extends Form implements InputFilterProviderInterface {

    public static $vendor_drivers = [];
    public static $modelYear = [];
    public static $vehicle_list = [];

    public function __construct($name = null) {

        parent::__construct('vehicle-detail-mapping-form');
        $this->setAttribute('method', 'post');

       
        
        /**
         *
         * Vehicle Name
         */
        $this->add([
            'name' => 'vehicle_name_mapping',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-name-mapping',
                'placeholder' => 'Vehicle Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vehicle Name',
                'empty_option' => ' -- Select Vehicle Name -- ',
                'value_options' => self::$vehicle_list,
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle Model
         */
        $this->add([
            'name' => 'model_year',
            'type' => Select::class,
            'attributes' => [
                'id' => 'model-year',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Model Year',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$modelYear,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select'
            ],
        ]);
      

      
//        /**
//         * Vehicle Number
//         */
//        $this->add([
//            'name' => 'vehicle_number',
//            'type' => Text::class,
//            'attributes' => [
//                'id' => 'vehicle-number',
//                'placeholder' => 'DL-0000',
//                'class' => 'form-control inputchange',
//                'maxlength'=>60,
//               
//            ],
//            'options' => [
//                'label' => 'Vehicle Number',
//                'label_options' => ['disable_html_escape' => true]
//            ],
//        ]);
        
         

        /**
         * Cab Type
         */
        $this->add([
            'name' => 'driver_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'driver-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Drivers',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => ' --Select Driver-- ',
                'value_options' => self::$vendor_drivers
               
            ],
        ]);

      
        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-red btn-warning reset_btn'
            ],
        ]);

        
        /**
         * Vehicle Model Id
         */
        $this->add([
            'name' => 'vehicle_model_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle-model-id'
            ],
        ]);
        /**
         * Vehicle Model Id
         */
        $this->add([
            'name' => 'vehicle_model_mapid',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle-model-mapid'
            ],
        ]);
        
        /**
         * Vehicle insert
         */
        $this->add([
            'name' => 'mapped_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'mapped_id'
            ],
        ]);
        
       
        
         /**
         * Submit
         */
        $this->add([
            'name' => 'mapping_submit',
            'type' => Submit::class,
            'attributes' => [
            'value' => 'Save',
                'id' => 'mapping-submit',
                'class' => 'btn btn-primary',
                'onclick' => "submitForm('#vehicle-detail-mapping-form', event);"
            ],
        ]);
    }
    public function getInputFilterSpecification() {
        return [
            'vehicle_name_mapping' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_type_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            ];
    }

}
