<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Text,
    Radio,
    Submit,
    Hidden
};


class VehicleDetailMapDriverForm extends Form {
    public static $cabType = [];
    public static $cityList = [];
    public static $stateList = [];


    public function __construct($name = null) {
        //echo "Amir Raza"; exit();

        parent::__construct('vehicle-detail-map-driver');
        $this->setAttribute('method', 'post');

         /**
         *
         * cab Types
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vehicle Type<span style="color: red"> *</span>',
                'empty_option' => 'Select',
                'value_options' => self::$cabType,
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
            ],
        ]);
        /**
         *
         * State
         */
        $this->add([
            'name' => 'state_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'State<span style="color: red"> *</span>',
                'value_options' => self::$stateList
            ]
        ]);

        /**
         *
         * city
         */
        $this->add([
            'name' => 'city_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'value_options' => self::$cityList
            ]
        ]);

        /**
         *Driver Name
         */
        $this->add([
            'name' => 'driver_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-name',
                'placeholder' => 'Driver Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         * Driver Value
         */
        $this->add([
            'name' => 'driver_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'driver-value'
            ],
        ]);

       /**
         *Vehicle Number
         */
        $this->add([
            'name' => 'vehicle_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => 'DL-6767',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         * Vehicle Value
         */
        $this->add([
            'name' => 'vehicle_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'vehicle-value'
            ],
        ]);

        /**
         *
         * Status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active-status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         *
         * Status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'deactive-status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
    }

}
