<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class VehicleAmenitiesForm extends Form implements InputFilterProviderInterface {

    public static $amenitiestype = [];

    public function __construct($name = null) {

        parent::__construct('vehicle-amenities-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * vehicle Amenities Type
         */
        $this->add([
            'name' => 'vehicle_amenities_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-amenities-type',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Amenities Type',
                'value_options' => self::$amenitiestype,
                'empty_option' => 'Select Amenities Type',
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_amenities_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-amenities-name',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Amenities',
            ],
        ]);

        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_amenities_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-amenities-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_amenities',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-amenities',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_amenities',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-vehicle-amenities',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Add Amenities'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_amenities',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'edit-vehicle-amenities',
                'placeholder' => 'Edit Amenities',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Edit Amenities'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'vehicle_amenities_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Amenities'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_amenities_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Amenities'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
