<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Date
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class UserAddShareForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];

    public function __construct($name = null) {

        parent::__construct('user-share-fare');

        $this->setAttribute('method', 'post');

        /**
         *
         * Basic tax
         */
        $this->add([
            'name' => 'company_share',
            'type' => Text::class,
            'attributes' => [
                'id' => 'company-share',
                'placeholder' => 'Enter Value',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Company Share',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         *
         */
        $this->add([
            'name' => 'company_share_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'company-share-type-id',
                'class' => 'form-control',
                'value' => 1
            ],
        ]);

        /**
         *
         *
         */
        $this->add([
            'name' => 'partner_share_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'partner-share-type-id',
                'class' => 'form-control',
                'value' => 2
            ],
        ]);


        /**
         *
         *
         */
        $this->add([
            'name' => 'driver_share_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'driver-share-type-id',
                'class' => 'form-control',
                'value' => 3
            ],
        ]);


        /**
         *
         * krishi kalyan cess
         */
        $this->add([
            'name' => 'partner_share',
            'type' => Text::class,
            'attributes' => [
                'id' => 'partner-share',
                'placeholder' => 'Enter Value',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Partner Share',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * swatch bharat cess
         */
        $this->add([
            'name' => 'driver_share',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-share',
                'placeholder' => 'Enter Value',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Driver Share',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'share-fare-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-primary btn-warning',
                'Value' => 'Save'
            ],
        ]);

        /**
         *
         * next
         */
        $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px',
                'value' => 'Next'
            ],
        ]);

        $this->add([
            'name' => 'comp_share_id',
            'type' => Hidden::class,
        ]);

        $this->add([
            'name' => 'partner_share_id',
            'type' => Hidden::class,
        ]);

        $this->add([
            'name' => 'driver_share_id',
            'type' => Hidden::class,
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'company_share' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Company Share'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'partner_share' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Partner Share'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'driver_share' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Driver Share'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
