<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};

class ThirdPartyForm extends Form {

    public static $map_style = [];
    public static $captcha_type = [];
    public static $role = [];

    public function __construct($name = null) {

        parent::__construct('third-party-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Googlemaps pin Logo
         */
        $this->add([
            'name' => 'google_map_pin_logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'google-map-pin-logo-id',
                'placeholder' => '80',
                'class' => 'col-sm-4 col-xs-12 control-label'
            ],
            'options' => [
                'label' => 'Googlemaps pin Logo',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Maps API Key
         */
        $this->add([
            'name' => 'map_api_key',
            'type' => Text::class,
            'attributes' => [
                'id' => 'map-api-key-id',
                'placeholder' => 'AIzaSyA0NLyJQnE1oZiJNIU_L9TWWTD1BoxY78M',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Maps API Key',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Select displays style of map
         */
        $this->add([
            'name' => 'map_style',
            'type' => Select::class,
            'attributes' => [
                'id' => 'style-of-map-id',
                'placeholder' => '80',
                'class' => 'col-sm-4 col-xs-12 control-label'
            ],
            'options' => [
                'label' => 'Select displays style of map',
                'value_options' => self::$map_style,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);

        /**
         *
         * Maximum number of places to mark
         */
        $this->add([
            'name' => 'no_mark_place',
            'type' => Text::class,
            'attributes' => [
                'id' => 'max-num-mark-id',
                'placeholder' => '50',
                'class' => 'form-control width50px',
            ],
            'options' => [
                'label' => 'Maximum number of places to mark',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * The initial Map Multi Point zoom level
         */
        $this->add([
            'name' => 'multipoint_zoom_level',
            'type' => Text::class,
            'attributes' => [
                'id' => 'map-multi-point-zoom-level-id',
                'placeholder' => '2',
                'class' => 'form-control width50px',
            ],
            'options' => [
                'label' => 'The initial Map Multi Point zoom level',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * The initial Map Single Point zoom level
         */
        $this->add([
            'name' => 'singlepoint_zoom_level',
            'type' => Text::class,
            'attributes' => [
                'id' => 'map-single-point-zoom-level-id',
                'placeholder' => '2',
                'class' => 'form-control width50px',
            ],
            'options' => [
                'label' => 'The initial Map Single Point zoom level',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Default Latitude
         */
        $this->add([
            'name' => 'default_latitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'default-latitude-id',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Default Latitude',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * Default Longitude
         */
        $this->add([
            'name' => 'default_longitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'default-longitude-id',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Default Longitude',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * Set Captcha type:
         */
        $this->add([
            'name' => 'captcha_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'captcha-type-id',
                'placeholder' => '80',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Set Captcha type:',
                'value_options' => self::$captcha_type,
                'empty_option' => 'Select',
                'disable_inarray_validator' => true,
            ],
        ]);
        
        $this->add([
            'name' => 'captcha_key',
            'type' => Text::class,
            'attributes' => [
                'id' => 'captcha-key',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Captcha Key',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * App id  :
         */
        $this->add([
            'name' => 'facebook_api_key',
            'type' => Text::class,
            'attributes' => [
                'id' => 'app-id',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'App id ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Client id  :
         */
        $this->add([
            'name' => 'google_client_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'Client-id-google',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Client id',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Secret id  :
         */
        $this->add([
            'name' => 'google_secret_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'secret-id-google',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Secret id ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Redirect Url
         */
        $this->add([
            'name' => 'google_redirect_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'redirect-url-google-id',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Redirect Url ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Client id
         */
        $this->add([
            'name' => 'linkedin_client_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'Client-id-linkedin',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Client id',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Secret id
         */
        $this->add([
            'name' => 'linkedin_secret_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'secret-id-linkedin',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Secret id ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Redirect Url
         */
        $this->add([
            'name' => 'linkedin_redirect_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'redirect-url-kinkedin-id',
                'placeholder' => '50',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Redirect Url ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Tawk Script:
         */
        $this->add([
            'name' => 'tawkchat_script',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'tawk-script-id',
                'placeholder' => '',
                'class' => 'form-control',
                'rows'=>12
            ],
            'options' => [
                'label' => 'Tawk Script',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
                /**
         *
         * SMTP HOST
         */
        $this->add([
            'name' => 'smtp_host',
            'type' => Text::class,
            'attributes' => [
                'id' => 'smtp_host',
                'placeholder' => '',
                'class' => 'form-control ',
            ],
            'options' => [
                'label' => 'SMTP HOST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * SMTP USERNAME
         */
        $this->add([
            'name' => 'smtp_username',
            'type' => Text::class,
            'attributes' => [
                'id' => 'smtp_username',
                'placeholder' => '',
                'class' => 'form-control ',
            ],
            'options' => [
                'label' => 'SMTP USERNAME',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * SMTP PASSWORD
         */
        $this->add([
            'name' => 'smtp_password',
            'type' => Text::class,
            'attributes' => [
                'id' => 'smtp_password',
                'placeholder' => '',
                'class' => 'form-control ',
            ],
            'options' => [
                'label' => 'SMTP PASSWORD',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * SMTP PORT
         */
        $this->add([
            'name' => 'smtp_port',
            'type' => Text::class,
            'attributes' => [
                'id' => 'smtp_port',
                'placeholder' => '',
                'class' => 'form-control ',
            ],
            'options' => [
                'label' => 'SMTP PORT',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * button System Backup
         */
        $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'fa fa-floppy',
            ],
        ]);

        /**
         *
         * button  restore
         */
        $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'fa fa-share',
            ],
        ]);

        /**
         *
         * button reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'fa fa-retweet',
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'third-party-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#third-party-form', event);"
            ],
        ]);
    }

}
