<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Textarea;

class TemplateSettingsForm extends Form {

    public function __construct($name = null) {

        parent::__construct('template-settings-form');
        $this->setAttribute('method', 'post');
        
        /**
         * 
         * System Default Font
         */
        $this->add([
            'name' => 'system_default_font',
            'type' => Select::class,
            'attributes' => [
                'id' => 'system-default-font',                
                'class' => ''
            ],
            'options' => [
                'label' => 'System Default Font<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Topbar Background
         */
        $this->add([
            'name' => 'topbar_background',
            'type' => Text::class,
            'attributes' => [
                'id' => 'topbar-background',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Topbar Background<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Menu Background Color
         */
        $this->add([
            'name' => 'menu_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'menu-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Menu Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Header phone number color
         */
        $this->add([
            'name' => 'header_phone_number_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'header-phone-number-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Header phone number color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Header phone number label color
         */
        $this->add([
            'name' => 'header_phone_number_label_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'header-phone-number-label-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Header phone number label color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Header background color
         */
        $this->add([
            'name' => 'header_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'header-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Header background color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Prefooter Background Color
         */
        $this->add([
            'name' => 'prefooter_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefooter-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Prefooter Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * facebook Backgroundcolor on mousehover
         */
        $this->add([
            'name' => 'facebook_background_color_on_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'facebook-background-color-on-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'facebook Backgroundcolor on mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * facebook Icon Color before mousehover
         */
        $this->add([
            'name' => 'facebook_icon_color_before_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'facebook-icon-color-before-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'facebook Icon Color before mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Googleplus Backgroundcolor on mousehover
         */
        $this->add([
            'name' => 'googleplus_background_color_on_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'googleplus-background-color-on-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Googleplus Backgroundcolor on mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Googleplus Icon Color before mousehover
         */
        $this->add([
            'name' => 'googleplus_icon_color_before_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'googleplus-icon-color-before-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Googleplus Icon Color before mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Twitter Backgroundcolor on mousehover
         */
        $this->add([
            'name' => 'twitter_background_color_on_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'twitter-background-color-on-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Twitter Backgroundcolor on mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Twitter Icon Color before mousehover
         */
        $this->add([
            'name' => 'twitter_icon_color_before_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'twitter-icon-color-before-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Twitter Icon Color before mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Youtube Backgroundcolor on mousehover
         */
        $this->add([
            'name' => 'youtube_background_color_on_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'youtube-background-color-on-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Youtube Backgroundcolor on mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Youtube Icon Color before mousehover
         */
        $this->add([
            'name' => 'youtube_icon_color_before_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'youtube-icon-color-before-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Youtube Icon Color before mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Go Top Button Background Color
         */
        $this->add([
            'name' => 'go_top_button_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'go-top-button-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Go Top Button Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Go Top Button Background Color On Mousehover
         */
        $this->add([
            'name' => 'go_top_button_background_color_on_mouse_hover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'go-top-button-background-color-on-mouse-hover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Go Top Button Background Color On Mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Common Search Block Background Color
         */
        $this->add([
            'name' => 'common_search_block_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'common-search-block-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Common Search Block Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Common Search Block Underline Color
         */
        $this->add([
            'name' => 'common_search_block_underline_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'common-search-block-underline-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Common Search Block Underline Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Search Button Color
         */
        $this->add([
            'name' => 'search_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'search-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Search Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Search Tab Font Color
         */
        $this->add([
            'name' => 'search_tab_font_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'search-tab-font-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Search Tab Font Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Subtab Active Button Background color
         */
        $this->add([
            'name' => 'subtab_active_button_background_color',
           'type' => Text::class,
            'attributes' => [
                'id' => 'subtab-active-button-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Subtab Active Button Background color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Subtab Inactive Button font Color
         */
        $this->add([
            'name' => 'subtab_inactive_button_font_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'subtab-inactive-button-font-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Subtab Inactive Button font Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Subtab Inactive Button Border Color
         */
        $this->add([
            'name' => 'subtab_inactive_button_border_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'subtab-inactive-button-border-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Subtab Inactive Button Border Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Arrow Color in Bus SearchField
         */
        $this->add([
            'name' => 'arrow_color_in_bus_search_field',
            'type' => Text::class,
            'attributes' => [
                'id' => 'arrow-color-in-bus-search-field',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Arrow Color in Bus SearchField<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Arrow border Color in SearchField
         */
        $this->add([
            'name' => 'arrow_border_color_in_search_field',
            'type' => Text::class,
            'attributes' => [
                'id' => 'arrow-border-color-in-search-field',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Arrow border Color in SearchField<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Dropdown Plus Minus Color
         */
        $this->add([
            'name' => 'dropdown_plus_minus_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'dropdown-plus-minus-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Dropdown Plus Minus Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Global Map Button Color
         */
        $this->add([
            'name' => 'global_map_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'global-map-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Global Map Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Global Ribbon Color
         */
        $this->add([
            'name' => 'global_ribbon_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'global-ribbon-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Global Ribbon Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Global Edit Button Color
         */
        $this->add([
            'name' => 'global_edit_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'global-edit-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Global Edit Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Mobile App Container Background Color
         */
        $this->add([
            'name' => 'mobile_app_container_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'mobile-app-container-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Mobile App Container Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Top sign in BUtton Color
         */
        $this->add([
            'name' => 'top_sign_in_bUtton_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'top-sign-in-bUtton-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Top sign in BUtton Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Global Photo Container Bckground Color
         */
        $this->add([
            'name' => 'global_photo_container_bckground_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'global-photo-container-bckground-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Global Photo Container Bckground Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Member Area header and p and a Color
         */
        $this->add([
            'name' => 'member_area_header_and_p_and_a_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'member-area-header-and-p-and-a-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Member Area header and p and a Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Navbar Button Color
         */
        $this->add([
            'name' => 'navbar_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'navbar-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Navbar Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Navbar Email Button Color
         */
        $this->add([
            'name' => 'navbar_email_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'navbar-email-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Navbar Email Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Navbar Save Button Color
         */
        $this->add([
            'name' => 'navbar_save_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'navbar-save-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Navbar Save Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Label Color
         */
        $this->add([
            'name' => 'label_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'label-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Label Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Write Review Color
         */
        $this->add([
            'name' => 'write_review_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'write-review-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Write Review Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Submit Button Font Color
         */
        $this->add([
            'name' => 'submit_button_font_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'submit-button-font-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Submit Button Font Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Submit Button Background Color
         */
        $this->add([
            'name' => 'submit_button_background_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'submit-button-background-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Submit Button Background Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Continue Cart Button Color
         */
        $this->add([
            'name' => 'continue_cart_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'continue-cart-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Continue Cart Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Check Out Button Color
         */
        $this->add([
            'name' => 'check_out_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'check-out-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Check Out Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Inactive Header Color
         */
        $this->add([
            'name' => 'inactive_header_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'inactive-header-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Inactive Header Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * invoice button Color
         */
        $this->add([
            'name' => 'invoice_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'invoice-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'invoice button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Customer Cancel Button Color
         */
        $this->add([
            'name' => 'customer_cancel_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-cancel-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Customer Cancel Button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Customer checkout Button Colorcheckout
         */
        $this->add([
            'name' => 'customer_checkout_button_color_checkout',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-checkout-button-color-checkout',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Customer checkout Button Colorcheckout<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Email Subcription Block Header Color
         */
        $this->add([
            'name' => 'email_subcription_block_header_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-checkout-button-color-checkout',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Email Subcription Block Header Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Newsletter and button Color
         */
        $this->add([
            'name' => 'newsletter_and_button_color',
            'type' => Text::class,
            'attributes' => [
                'id' => 'newsletter-and-button-color',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'Newsletter and button Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * News Figure Color on Mousehover
         */
        $this->add([
            'name' => 'news_figure_color_on_mousehover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'news-figure-color-on-mousehover',                
                'class' => 'span3',
                'placeholder'=>'select color'
            ],
            'options' => [
                'label' => 'News Figure Color on Mousehover<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        /**
         * Save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'save',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]); 
    }

}
