<?php
namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class SightseeingGeneralInfoForm extends Form implements InputFilterProviderInterface {

    public static $languages= [];
    public static $sightseeing_category = [];
    public static $sightseeing_type = [];
    public static $seasons= [];
    public static $things_to_carry = [];

  
   

    public function __construct($name = null) {

        parent::__construct('sightseeing-general-info-form');
        
          $this->setAttribute('method', 'post');
         
        /**
         *
         * City
         */

        $this->add([
            'name' => 'city_search',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',              
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
                'class' => 'form-control',
            ],
        ]);

        
         /**
         * Sightseeing Name
         */
        
        $this->add([
            'name' => 'sightseeing_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sightseeing-name',
                'placeholder' => 'Sightseeing Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Sightseeing Name <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Latitude
         */
        $this->add([
            'name' => 'latitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'latitude',
                'placeholder' => 'Latitude',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Latitude <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * Longitude
         */
        $this->add([
            'name' => 'longitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'longitude',
                'placeholder' => 'Longitude',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Longitude <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
       
        /**
         * Address
         */
        $this->add([
            'name' => 'address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pac-input',
                'placeholder' => 'Address',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Address <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
   
        /**
         *  coverage kilometre
         */
        
        $this->add([
            'name' => 'coverage_kilometre',
            'type' => Text::class,
            'attributes' => [
                'id' => 'coverage-kilometre',
                'placeholder' => 'Coverage kilometre',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Coverage kilometre<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *  Coverage hours 
         */
        
        $this->add([
            'name' => 'coverage_hours',
            'type' => Text::class,
            'attributes' => [
                'id' => 'coverage-hours',
                'placeholder' => 'Coverage hours',
                'class' => 'form-control inputchange',
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Coverage hours<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * Category
         */
        
        $this->add([
            'name' => 'category',
            'type' => Select::class,
            'attributes' => [
                'id' => 'category',
                'placeholder' => 'Category',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
                 
            ],
            'options' => [
                'label' => 'Category <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$sightseeing_category,
                
            ],
        ]);
        
         /**
         * Sightseeing Type
         */
        
        $this->add([
            'name' => 'Sightseeing_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'sightseeing-type',
                'placeholder' => 'Sightseeing type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Sightseeing type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$sightseeing_type,
            ],
        ]);
        
        
         /**
         * 
         * Difficulty Level

         */
         $this->add([
            'name' => 'difficulty_level',
            'type' => Select::class,
            'attributes' => [
                'id' => 'difficulty-level',
                'placeholder' => 'Difficulty level',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Difficulty level <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Level--',
                'required'=>false,
                'value_options' =>[
                             'Difficult' => 'Difficult',
                             'Easy' => 'Easy',
                             'Hard' => 'Hard',
                             'Moderate' => 'Moderate',
                     ]
            ],
        ]);
      
        /**
         * Season
         */
        
        $this->add([
            'name' => 'season',
            'type' => Select::class,
            'attributes' => [
                'id' => 'season',
                'placeholder' => 'season',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
                'disable_inarray_validator' => true
            ],
            'options' => [
                'label' => 'Season <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$seasons,
                
            ],
            
        ]);
        
        /**
         * Languages
         */
        
        $this->add([
            'name' => 'languages',
            'type' => Select::class,
            'attributes' => [
                'id' => 'languages',
                'placeholder' => 'languages',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
                'disable_inarray_validator' => true
            ],
            'options' => [
                'label' => 'Languages <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$languages,
                
            ],
            
        ]);
        
      
        /**
         * 
         *  Popularity

         */
         $this->add([
            'name' => 'popularity',
            'type' => Select::class,
            'attributes' => [
                'id' => 'popularity',
                'placeholder' => 'Popularity',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Popularity <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Popularity--',
                'value_options' =>[
                             '1' => 'Low',
                             '2' => 'Medium',
                             '3' => 'High',
                            
                     ]
            ],
        ]);
         
        /**
         * Things to Carry
         */
        
        $this->add([
            'name' => 'things_to_carry',
            'type' => Select::class,
            'attributes' => [
                'id' => 'things-to-carry',
                'placeholder' => 'Things To Carry',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Things To Carry <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '',
                'value_options' => self::$things_to_carry,
            ],
        ]);
        /**
         * Sightseeing cover 
         */
        
        $this->add([
            'name' => 'sightseeing_cover',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sightseeing-cover',
                'placeholder' => 'Sightseeing cover',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Sightseeing cover <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);
        
        
         
      
        /**
         * You Tube URL
         */
        
        $this->add([
            'name' => 'youtube_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'youtube-url',
                'placeholder' => 'YouTube URL',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'YouTube URL <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * About Sightseeing
         */
        $this->add([
            'name' => 'about_sightseeing',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'about-sightseeing',
                'placeholder' => 'About Sightseeing',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'About Sightseeing <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Highlights
         */
        $this->add([
            'name' => 'highlights',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'highlights',
                'placeholder' => 'Highlights',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Highlights <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Meeting points
         */
        $this->add([
            'name' => 'meeting_point',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meeting_point',
                'placeholder' => 'Meeting points',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Meeting Points <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * Is Unique
         */
          
             $this->add([
            'name' => 'is_unique',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'is-unique',
                //'checked' => 'checked',
                'class' => 'form-control inputchange case'
            ],
            'options' => [
                'label' => 'Is Unique',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => false
            ],
        ]);
       
       

        /**
         * Submit
         */
        $this->add([
            'name' => 'Submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning'
            ],
        ]);
        
        
         $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);
        
             
    }
    public function getInputFilterSpecification() {
        return [
            'is_unique' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'city_search' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'sightseeing_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Sightseeing Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'latitude' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Latitude'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'longitude' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Longitude'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'category' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'Sightseeing_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sightseeing Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'coverage_kilometre' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Coverage Kilometre'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'coverage_hours' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Coverage hours'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'difficulty_level' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Difficulty Levels'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'season' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Seasons'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'popularity' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Popularity'
                             
                            ]
                        ],
                        'break_chain_on_failure' =>true
                    ]
                ]
            ],  
            'things_to_carry' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Things  To Carry'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'youtube_url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Youtube Url'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            'sightseeing_cover' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Sightseeing Cover '
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'about_sightseeing' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide About Sightseeing'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            'highlights' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Sighseeing Highlights'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'languages' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Languages'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
            ];
    }

}
