<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Number;


class SetupGlobalSettingPageManagementForm extends Form {
    
    public static $default_home_page=[];
    public static $set_metadata=[];

    public function __construct($name = null) {

        parent::__construct('profile-personal');

        $this->setAttribute('method', 'post');
        
        
          /**
         * 
         * Default Home Page
         */
          $this->add([
            'name' => 'default_home_page',
            'type' => Select::class,
            'attributes' => [
                'id' => 'default-home-page-id',  
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Default Home Page',
                'value_options' => self::$default_home_page
            ],
        ]);
          
            /**
         * 
         * Default Number of list item per page
         */
          $this->add([
            'name' => 'default_number',
            'type' => Number::class,
            'attributes' => [
                'id' => 'default-number-id',  
                'placeholder' => '10',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Default Number of list item per page',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
          
          
            /**
         * 
         * Meta title seperator
         */
           $this->add([
            'name' => 'meta_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title-id',  
                'placeholder' => 'seperator',
                'class' => 'form-control',
                
            ],
            'options' => [
                'label' => 'Meta title seperator',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
           /**
         * 
         * How set meta
         */
          $this->add([
            'name' => 'how_set_meta',
            'type' => Select::class,
            'attributes' => [
                'id' => 'how-set-meta-id',  
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'How set meta',
                'value_options' => self::$set_metadata
            ],
        ]);
          
           
          
       /**
         * 
         * button System Backup
         */
         $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',    
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],
           
        ]);
          
         /**
         * 
         * button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',    
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],
           
        ]);
          
            
         /**
         * 
         * button reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',    
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],
           
        ]);
          
          /**
         * 
         * button Save
         */
          $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-id',    
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning',
            ],
           
        ]);  
          
    }

}
