<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress,
    Identical
};
use Zend\Validator\File\Size;

class SecurityForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('security');
        $this->setAttribute('method', 'post');

        /**
         * Submit
         */
        $this->add([
            'name' => 'profile_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-submit',
                'value' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);
    }

    public function getInputFilterSpecification() {
        return [
        ];
    }

}
