<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class RefundPolicyForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];
    public static $country = [];

    public function __construct($name = null) {

        parent::__construct('cancellation-policy-form');

        /**
         * 
         * Country ...
         */
        $this->add([
            'name' => 'country_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'country-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Country <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);

        /**
         * 
         * booking type ...
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);


        /* $this->add([
          'name' => 'booking_type',
          'type' => Select::class,
          'attributes' => [
          'id' => 'booking_type',
          'class' => 'selectpicker form-control',
          'data-show-subtext'=>true,
          'data-live-search'=>true,
          'style'=>'display: none'
          ],
          'options' => [
          'disable_inarray_validator' => true,
          'empty_option' => ' -- Select Booking Type -- ',
          'value_options' => [
          '1' => 'Domestic FIT',
          '2' => 'Domestic Group',
          '3' => 'International Group',
          '4' => 'International Fit',
          '5' => 'Inbound Fit',
          '6' => 'Inbound Group',
          '7' => 'Domestic Hotel Booking',
          '8' => 'International Hotel Booking',

          ],
          ],
          ]); */

        /**
         * 
         * Inclusions Name...
         */
        $this->add([
            'name' => 'title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'title',
                'placeholder' => 'title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Thumb Image...
         */
        $this->add([
            'name' => 'thumb_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'thumb-image',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Thumb Image<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * 
         * Description ...
         */
        $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'country_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
//          'thumb_image' => [
//                'required' => true,
//                'filters' => [
//                    ['name' => 'StripTags'],
//                    ['name' => 'StringTrim']
//                ],
//                'validators' => [
//                    ['name' => 'NotEmpty',
//                        'options' => [
//                            'messages' => [
//                                NotEmpty::IS_EMPTY => 'Please Upload Thumb Image'
//                            ]
//                        ],
//                        'break_chain_on_failure' => true
//                    ]
//                ]
//            ],
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Give Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
