<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class ProfileLicenseDetailForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('profile-license-detail');
        $this->setAttribute('method', 'post');

        /**
         * License state...
         */
        $this->add([
            'name' => 'license_state',
            'type' => Text::class,
            'attributes' => [
                'id' => 'license-state',
                'placeholder' => 'Select state',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'License state<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License State Value...
         */
        $this->add([
            'name' => 'license_state_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'license-state-value'
            ],
        ]);

        /**
         * badge/License No
         */
        $this->add([
            'name' => 'driving_license_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'badge-license-number',
                'placeholder' => '',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Badge/License No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License Prrof
         */
        $this->add([
            'name' => 'license_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'license-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'license_proof'
            ],
            'options' => [
                'label' => 'License Proof<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * License Validity
         */
        $this->add([
            'name' => 'license_validity',
            'type' => text::class,
            'attributes' => [
                'id' => 'license-validity',
                'placeholder' => '',
                'class' => 'form-control datepicker',
                'readonly'=> true
            ],
            'options' => [
                'label' => 'License Validity<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Insurance Validity
         */
        $this->add([
            'name' => 'insurance_validity',
            'type' => text::class,
            'attributes' => [
                'id' => 'insurance-validity',
                'placeholder' => '',
                'class' => 'form-control inputchange datepicker'
            ],
            'options' => [
                'label' => 'Insurance Validity<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * GPS Device No
         */
        $this->add([
            'name' => 'gps',
            'type' => Text::class,
            'attributes' => [
                'id' => 'gps-device-number',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'GPS Device No',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pancard
         */
        $this->add([
            'name' => 'pancard_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pancard',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Pancard<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pancard Proof
         */
        $this->add([
            'name' => 'pancard_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'pancard-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'pancard_proof'
            ],
            'options' => [
                'label' => 'Pancard Proof<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Police Report
         */
        $this->add([
            'name' => 'police_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'police-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'police_proof'
            ],
            'options' => [
                'label' => 'Police Report<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Audit Report
         */
        $this->add([
            'name' => 'audit_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'audit-proof',
                'class' => 'form-control common-upload-file',
                'data-level-name' => 'audit_proof'
            ],
            'options' => [
                'label' => 'Audit Report<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'license_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'license_reset',
                'placeholder' => 'Reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],
        ]);

        /**
         * Save
         */
        $this->add([
            'name' => 'license_save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'license-save',
                'value' => 'Save',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'user_id',
            ],    
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'id',
            'type' => Text::class
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            /**
             * Name
             */
            'license_state' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter License State'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'driving_license_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Driving License No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'license_validity' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter License Validity'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
//                    ['name' => 'Date',
//                        'options' => [
//                            'messages' => [
//                                //Date::INVALID_DATE => '',
//                                \Zend\Validator\Date::INVALID_DATE => '',
//                            ],
//                        ],
//                        'break_chain_on_failure' => true
//                    ],
                ]
            ],
            'insurance_validity' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Insurance Validity'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
//                    ['name' => 'Date',
//                        'options' => [
//                            'messages' => [
//                                //Date::INVALID_DATE => '',
//                                \Zend\Validator\Date::INVALID_DATE => '',
//                            ],
//                        ],
//                        'break_chain_on_failure' => true
//                    ],
                ]
            ],
            'gps' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter GPS'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pancard_no' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Pancard No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
                /* 'license_proof' => [
                  'required' => true,
                  'filters' => [
                  ['name' => 'StripTags'],
                  ['name' => 'StringTrim']
                  ],
                  'validators' => [
                  [   'name' => 'NotEmpty',
                  'options' => [
                  'messages' => [
                  NotEmpty::IS_EMPTY => 'File was not uploaded'
                  ]
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileUploadFile'],
                  [
                  'name'    => 'FileMimeType',
                  'options' => [
                  'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileIsImage'],
                  [
                  'name'    => 'FileImageSize',
                  'options' => [
                  'minWidth'  => 128,
                  'minHeight' => 128,
                  'maxWidth'  => 4096,
                  'maxHeight' => 4096
                  ]
                  ],
                  ]
                  ],

                  'pancard_proof' => [
                  'required' => true,
                  'filters' => [
                  ['name' => 'StripTags'],
                  ['name' => 'StringTrim']
                  ],
                  'validators' => [
                  [   'name' => 'NotEmpty',
                  'options' => [
                  'messages' => [
                  NotEmpty::IS_EMPTY => 'File was not uploaded'
                  ]
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileUploadFile'],
                  [
                  'name'    => 'FileMimeType',
                  'options' => [
                  'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileIsImage'],
                  [
                  'name'    => 'FileImageSize',
                  'options' => [
                  'minWidth'  => 128,
                  'minHeight' => 128,
                  'maxWidth'  => 4096,
                  'maxHeight' => 4096
                  ]
                  ],
                  ]
                  ],

                  'police_proof' => [
                  'required' => true,
                  'filters' => [
                  ['name' => 'StripTags'],
                  ['name' => 'StringTrim']
                  ],
                  'validators' => [
                  [   'name' => 'NotEmpty',
                  'options' => [
                  'messages' => [
                  NotEmpty::IS_EMPTY => 'File was not uploaded'
                  ]
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileUploadFile'],
                  [
                  'name'    => 'FileMimeType',
                  'options' => [
                  'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileIsImage'],
                  [
                  'name'    => 'FileImageSize',
                  'options' => [
                  'minWidth'  => 128,
                  'minHeight' => 128,
                  'maxWidth'  => 4096,
                  'maxHeight' => 4096
                  ]
                  ],
                  ]
                  ],

                  'audit_proof' => [
                  'required' => true,
                  'filters' => [
                  ['name' => 'StripTags'],
                  ['name' => 'StringTrim']
                  ],
                  'validators' => [
                  [   'name' => 'NotEmpty',
                  'options' => [
                  'messages' => [
                  NotEmpty::IS_EMPTY => 'File was not uploaded'
                  ]
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileUploadFile'],
                  [
                  'name'    => 'FileMimeType',
                  'options' => [
                  'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                  ],
                  'break_chain_on_failure' => true
                  ],
                  ['name'    => 'FileIsImage'],
                  [
                  'name'    => 'FileImageSize',
                  'options' => [
                  'minWidth'  => 128,
                  'minHeight' => 128,
                  'maxWidth'  => 4096,
                  'maxHeight' => 4096
                  ]
                  ],
                  ]
                  ], */
        ];
    }

}
