<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\ElementTextarea;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Submit;

class PackageSearchForm extends Form {
   

    public function __construct($name = null) {

        parent::__construct('package-search-form');
        
        /**
         * 
         * Tour Name...
         */
        $this->add([
            'name' => 'tour_name',
             'type' => Text::class,
            'attributes' => [
                'id' => 'tour-name',                  
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Day(s)...
         */
        $this->add([
            'name' => 'number_of_days',
             'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-days',                  
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Day(s)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Owner...
         */
        $this->add([
            'name' => 'owner_name',
             'type' => Select::class,
            'attributes' => [
                'id' => 'owner-name',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Owner<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Status...
         */
        $this->add([
            'name' => 'status',
             'type' => Select::class,
            'attributes' => [
                'id' => 'status',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Type...
         */
        $this->add([
            'name' => 'hotel_type',
             'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-type',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * 
         * Country...
         */
        $this->add([
            'name' => 'country_name',
             'type' => Select::class,
            'attributes' => [
                'id' => 'country-name',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Country<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * 
         * State...
         */
        $this->add([
            'name' => 'state_name',
             'type' => Select::class,
            'attributes' => [
                'id' => 'state-name',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'State<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * 
         * Area...
         */
        $this->add([
            'name' => 'area',
             'type' => Select::class,
            'attributes' => [
                'id' => 'area',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Area<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * 
         * Price...
         */
        $this->add([
            'name' => 'price',
             'type' => Text::class,
            'attributes' => [
                'id' => 'price',                  
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Price<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 

        /**
         * 
         * Search...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);  
        
        /**
         * 
         * Clear...
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);  
    }

}
