<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class PackageAvailabilityOthersForm extends Form implements InputFilterProviderInterface {

    public static $country = [];
    public static $payment_structure = [];
    public static $documentation = [];
    public static $cancellation_policy = [];
    public static $refund_policy = [];
    public static $term_policy = [];
    public static $tours = [];

    public function __construct($name = null) {
        parent::__construct('package-available-other-form');
        
        /**
         * 
         * Tours ...
         */
        $this->add([
            'name' => 'tour_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tour-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Tour Package<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tours,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Tours--',
            ],
        ]);

        /**
         * 
         * Tours Package Available From
         *
         */
        $this->add([
            'name' => 'tours_package_available_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'tours-package-available-from',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tours Package Available From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Tours Package Expire Date
         *
         */
        $this->add([
            'name' => 'tours_package_expire_date',
            'type' => text::class,
            'attributes' => [
                'id' => 'tours-package-expire-date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tours Package Expiry Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Google Map Details
         */
        $this->add([
            'name' => 'google_map',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'google-map',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Google Map<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Tour Highlights
         */
        $this->add([
            'name' => 'tour_highlights',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'tour-highlights',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Tour Highlights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Available Country ...
         */
        $this->add([
            'name' => 'availability_country',
            'type' => Select::class,
            'attributes' => [
                'id' => 'available-country',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Available Country <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);

        /**
         * 
         * Destination | Area City
         */
        
        $this->add([
            'name' => 'available_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Available City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'destination_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);


        /**
         * 
         * Payment Structure
         */
        $this->add([
            'name' => 'payment_structure_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-structure-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Payment Structure<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$payment_structure,
                'disable_inarray_validator' => true,
                'empty_option' => '--Payment Structure--',
            ],
        ]);
        
        /**
         * 
         * Payment Structure Content
         */
        $this->add([
            'name' => 'payment_structure_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'payment-structure-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        

        /**
         * 
         * Document Structure
         */
        $this->add([
            'name' => 'document_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'document-id',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Documentation<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$documentation,
                'disable_inarray_validator' => true,
                'empty_option' => '--Documentation--',
            ],
        ]);
        
        /**
         * 
         * Documentation Content
         */
        $this->add([
            'name' => 'documentation_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'documentation-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        /**
         * 
         * Cancellation Policy
         */
        $this->add([
            'name' => 'cancellation_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Cancellation Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$cancellation_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Cancellation Policy--',
            ],
        ]);
        
        /**
         * 
         * Cancellation Policy Content
         */
        $this->add([
            'name' => 'cancellation_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'cancellation-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);      
        
        /**
         * 
         * Refund Policy
         */
        $this->add([
            'name' => 'refund_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'refund-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Refund Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$refund_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Refund Policy--',
            ],
        ]);
        
        /**
         * 
         * Refund Policy Content
         */
        $this->add([
            'name' => 'refund_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'refund-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        
        /**
         * 
         * Term Policy
         */
        $this->add([
            'name' => 'term_policy',
            'type' => Select::class,
            'attributes' => [
                'id' => 'term-policy',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Term Policy<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$term_policy,
                'disable_inarray_validator' => true,
                'empty_option' => '--Term Policy--',
            ],
        ]);
        
        /**
         * 
         * Term Policy Content
         */
        $this->add([
            'name' => 'term_policy_content',
            'text' => Textarea::class,
            'attributes' => [
                'id' => 'term-policy-content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'tour_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Tour'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_highlights' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Tour Highlights'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'google_map' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Google Map Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_structure_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Payment Structure Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'documentation_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Documentation Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'cancellation_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Cancellation Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'refund_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Refund Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'term_policy_content' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Term Policy Content'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tours_package_available_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Available From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tours_package_expire_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Expiry Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'available_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Available City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'availability_country' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Available Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'payment_structure_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Payment Structure'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'document_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Documentation'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'cancellation_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Cancellation Policy'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'refund_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Refund Policy'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'term_policy' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Terms & Condition Policy'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
