<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class PackageAddForm extends Form implements InputFilterProviderInterface {

    public static $tour_type = [];
    public static $country = [];
    public static $city = [];
    public static $inclusion = [];
    public static $tour_theme = [];
    public static $tour_category = [];

    public function __construct($name = null) {
        parent::__construct('package-add-form');
        /**
         * General Information Tab
         * General Configuration
         * Tour Name
         */
        $this->add([
            'name' => 'tours_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tours-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Tour Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tour_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Tour Type--',
            ],
        ]);

        $this->add([
            'name' => 'tour_category[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tour-category',
                'placeholder' => '',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Tour Categories <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tour_category,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Tour Type--',
            ],
        ]);

        /**
         * 
         * Destination Country ...
         */
        $this->add([
            'name' => 'destination_country',
            'type' => Select::class,
            'attributes' => [
                'id' => 'destination-country',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Destination Country <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);

        /**
         * 
         * Destination | Area City
         */
        $this->add([
            'name' => 'destination_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Destination City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'destination_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);

        /**
         * 
         * Destination Post Code
         */
        $this->add([
            'name' => 'destination_post_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-post-code',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Destination Post Code<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * 
         * Tour Name
         */
        $this->add([
            'name' => 'tour_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tour-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Tours Operator
         */
        $this->add([
            'name' => 'tours_operator',
            'type' => Select::class,
            'attributes' => [
                'id' => 'tour-operator',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
                'style' => 'display: none'
            ],
            'options' => [
                'label' => 'Tour Operator<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Tour Operator -- ',
                'value_options' => [
                    '1' => 'Hello42cab',
                    '2' => 'Regency Tours',
                    '3' => 'Holiday Basket'
                ],
            ],
        ]);

        //--------------------Primary Information-------------------------------

        /**
         * Tours Features Tab
         * Start City
         */
        $this->add([
            'name' => 'start_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'start-city',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Start City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'start_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'start-city-id',
                'class' => 'form-control'
            ],
        ]);

        /**
         * 
         * End City
         */
        $this->add([
            'name' => 'end_city',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'end-city',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'End City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        $this->add([
            'name' => 'end_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'end-city-id',
                'class' => 'form-control'
            ],
        ]);


        /**
         * 
         * Destination covered
         */
        $this->add([
            'name' => 'destination_covered',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'destination-covered',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Destination Covered<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'destination_covered_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-covered-id',
                'class' => 'form-control'
            ],
        ]);

        /**
         * 
         * Inclusion
         */
        $this->add([
            'name' => 'inclusion[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'inclusion',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Inclusion<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$inclusion,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Inclusion--',
            ],
        ]);
        /**
         * 
         * Theme
         */
        $this->add([
            'name' => 'theme[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'theme',
                'class' => 'demo-default select-state selectized form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
                'style' => 'display: none'
            ],
            'options' => [
                'label' => 'Theme<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$tour_theme,
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Theme -- ',
            ],
        ]);


        /**
         * 
         * Traveler
         */
        $this->add([
            'name' => 'traveler',
            'type' => Select::class,
            'attributes' => [
                'id' => 'traveler',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Traveller<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Traveler -- ',
                'value_options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7'
                ],
            ],
        ]);

        /**
         * 
         * package Validity From
         *
         */
        $this->add([
            'name' => 'package_validity_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'package-validity-from',
                'class' => 'form-control datepicker'
            ]
        ]);


        /**
         * 
         * package Validity To
         *
         */
        $this->add([
            'name' => 'package_validity_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'package-validity-to',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Booking Validity From
         *
         */
        $this->add([
            'name' => 'booking_validity_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'booking-validity-from ',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Booking Validity To
         *
         */
        $this->add([
            'name' => 'booking_validity_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'booking-validity-to',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'Tour Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

               
        /*
         * Departure Date
         *
         */

        $this->add([
            'type' => Text::class,
            'name' => 'departure_date[]',
            'attributes' => [
                'id' => 'departure-date',
                'class' => 'form-control datepicker',
            ]
        ]);
        /*
         * Departure Time
         *
         */

        $this->add([
            'type' => Text::class,
            'name' => 'departure_time[]',
            'attributes' => [
                'id' => 'pickup-time',
                'class' => 'form-control timepicker'
            ]
        ]);


        $this->add([
            'type' => Textarea::class,
            'name' => 'short_desc',
            'attributes' => [
                'id' => 'page_desc',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Short Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Tour Code
         * 
         */
        $this->add([
            'name' => 'tour_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tour-code',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Tour Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * No. of Nights
         * 
         */
        $this->add([
            'name' => 'number_of_nights',
            'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-nights',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'No. of Nights<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * No. of Days
         */
        $this->add([
            'name' => 'number_of_days',
            'type' => Text::class,
            'attributes' => [
                'id' => 'number-of-days',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'No. of Days<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Rating(s)
         */
        $this->add([
            'name' => 'rating',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rating',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Rating(s)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Short Overview
         */
        $this->add([
            'name' => 'short_overview',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'short-overview',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Short Overview<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);

        /**
         * 
         * Number Of Night
         */
        $this->add([
            'name' => 'no_of_night',
            'type' => Text::class,
            'attributes' => [
                'id' => 'no-of-night',
                'class' => 'form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            //'style'=>'display: none'
            ],
        ]);

        /**
         * 
         * Meta description
         */
        $this->add([
            'name' => 'tour_operator',
            'type' => Text::class,
            'attributes' => [
                'id' => 'tour-operator',
                'class' => 'form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            //'style'=>'display: none'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'tours_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Tour Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_country' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_post_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Destination Postal Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Tour Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tours_operator' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Tour Operator'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'start_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Start City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'end_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select End City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_covered' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination Covered'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'inclusion[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Inclusion'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'theme[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Theme'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'traveler' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Traveler'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Tour Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'number_of_nights' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Nights'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'number_of_days' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'tour_category[]' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Tour Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'short_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Short Description..'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'group_tour' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please  Give short Description..'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'departure_date' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Addon Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'departure_time' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Addon Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'package_validity_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'package_validity_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter To Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_validity_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_validity_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter To Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
