<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class MembershipFeatureForm extends Form implements InputFilterProviderInterface {

    public static $vehicletype = [];

    public function __construct($name = null) {

        parent::__construct('feature-search-type');

        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

       

        /**
         *
         * Feature name
         */
        $this->add([
            'name' => 'feature_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'feature-name',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Feature Name',
            ],
        ]);
        
        /**
         *
         * Feature Description
         */
        $this->add([
            'name' => 'feature_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'feature-desc',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Feature Description',
            ],
        ]);

        /**
         *
         * Feature Image
         */
        $this->add([
            'name' => 'feature_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'feature-image',
                'class' => 'form-control'
            ],
            'options' => [
                 'label' => 'Feature Image',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);


        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'feature_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'feature-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Feature Id',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_feature',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-feature',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_feature',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-feature',
                'placeholder' => 'Add Feature',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_feature',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'edit-feature',
                'placeholder' => 'Edit Feature',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'feature_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Feature'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'feature_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Feature Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
