<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;

class MemberShipPackageAddNewForm extends Form {

    public function __construct($name = null) {

        parent::__construct('member-ship');

        $this->setAttribute('method', 'post');
        
        
        /**
         * 
         * Name of package
         */
        $this->add([
            'name' => 'package_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',  
                'class' => 'form-control',
                'placeholder' => 'Name',
                
            ],
            'options' => [
                'label' => 'Name of package',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Brief Description
         */
        $this->add([
            'name' => 'brief_desc',
            'type' => Text::class,
            'attributes' => [
                'id' => 'brief-desc-id',  
                'class' => 'form-control',
                'placeholder' => 'Brief Description',
                
            ],
            'options' => [
                'label' => 'Brief Description',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Base Price After Discount
         */
        $this->add([
            'name' => 'base_price',
            'type' => Text::class,
            'attributes' => [
                'id' => 'base-price-id',  
                'class' => 'form-control',
                'placeholder' => '100',
                
            ],
            'options' => [
                'label' => 'Base Price After Discount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Package renewal for (0 denotes forever or never expire)*
         */
        $this->add([
            'name' => 'package_renewable',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-renewable-id',  
                'class' => 'form-control',
                'placeholder' => 'Renew',
                
            ],
            'options' => [
                'label' => 'Package renewal for (0 denotes forever or never expire)*',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Package Renew Notification Mail Time: *
         */
        $this->add([
            'name' => 'package_renew_notify',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-renew-notify-id',  
                'class' => 'form-control',
                'placeholder' => 'Notification',
                
            ],
            'options' => [
                'label' => 'Package Renew Notification Mail Time: *',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        

    }
}