<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Textarea;
use Zend\Form\Element\Hidden;
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class LocalPackageFareForm extends Form implements InputFilterProviderInterface {

    public static $booking_mode_type = [];
    public static $booking_type = [];
    public static $country = [];

    public function __construct($name = null) {

        parent::__construct('local-package-form');

        $this->setAttribute('method', 'post');


        /**
         *
         * booking_mode_type
         */
        $this->add([
            'name' => 'booking_mode_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-mode-type',
                'class' => 'form-control',
            //'data-show-subtext' => 'true',
            //'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Mode<span style="color: red"> *</span>',
                'value_options' => self::$booking_mode_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Mode--',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--'
            ],
        ]);


        /**
         *
         * Package Name
         */
        $this->add([
            'name' => 'distance_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',
                'placelder' => '40Km',
                'class' => 'form-control allowtext',
                'maxlength' => 20,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Ignore HRS
         */
        $this->add([
            'name' => 'distance_ignore_hr[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-hr-id',
                'placeholder' => '1',
                'class' => 'form-control',
                'onkeypress' => "return isNumber(event)",
            ],
            'options' => [
                'label' => 'Ignore Hrs',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Ignore KM
         */
        $this->add([
            'name' => 'distance_ignore_km[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-km-id',
                'placeholder' => '1',
                'class' => 'form-control',
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Ignore KM',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * Package Name
         */
        $this->add([
            'name' => 'distance_package_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',
                'placeholder' => '40Km',
                'class' => 'form-control allowtext',
                'maxlength' => 20
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Ignore HRS
         */
        $this->add([
            'name' => 'distance_ignore_hr',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-hr-id',
                'placeholder' => '1',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Ignore Hrs',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Ignore KM
         */
        $this->add([
            'name' => 'distance_ignore_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-km-id',
                'placeholder' => '1',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Ignore KM',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * Amount
         */
        $this->add([
            'name' => 'distance_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pkg_amountDistance_1',
                'placeholder' => 'Rs',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-id',
                'placeholder' => 'Save',
                'class' => 'btn btn-success',
                'value' => 'Save'
            ],
        ]);
    }

    public function getInputFilterSpecification() {

        return [
            'booking_mode_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Mode'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
