<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class JobForm extends Form implements InputFilterProviderInterface {

     public static $department = [];

    public function __construct($name = null) {

        parent::__construct('job');
        $this->setAttribute('method', 'post');
        
        
        

         /**
         *
         * Department Name
         */
       $this->add([
            'name' => 'department_name',
            'type' => Select::class,
           'attributes' => [
                'id' => 'department-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
           'options' => [
                'label' => 'Department Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$department,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Department--',
            ]
        ]);

         /**
         *
         * Position Name
         */
       $this->add([
            'name' => 'position_name',
            'type' => Text::class,
           'attributes' => [
                'id' => 'position-name',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Position Name',
            ],
        ]);
       
         /**
         *
         * Experience
         */
       $this->add([
            'name' => 'experience',
            'type' => Text::class,
           'attributes' => [
                'id' => 'experience',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Experience',
            ],
        ]);
       
         /**
         *
         * Location
         */
       $this->add([
            'name' => 'location',
            'type' => Text::class,
           'attributes' => [
                'id' => 'location',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Location',
            ],
        ]);
       
         /**
         *
         * Description
         */
       $this->add([
            'name' => 'description',
            'type' => Text::class,
           'attributes' => [
                'id' => 'description',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Description',
            ],
        ]);
       
         /**
         *
         * Job Description
         */
       $this->add([
            'name' => 'job_description',
            'type' => Textarea::class,
           'attributes' => [
                'id' => 'job-description',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Job Description',
            ],
        ]);
       
         /**
         *
         * Skills
         */
       $this->add([
            'name' => 'skills',
            'type' => Textarea::class,
           'attributes' => [
                'id' => 'skills',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Skills',
            ],
        ]);
       
         /**
         *
         * Id
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'id',
            ],
        ]);
       
   
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Submit'
            ],
        ]);



    }
     public function getInputFilterSpecification() {
        return [
            'department_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Department Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'position_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Position Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'experience' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Experience Detail'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'location' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Location Detail'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'job_description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Job Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'skills' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Skills Detail'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
          
          

        ];
    }


}
