<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelRoomForm extends Form implements InputFilterProviderInterface {
    
    public static $hotel_list= [];
    public static $roomCategoryList= [];
    public static $roomTypeList= [];
    public static $paymentOptionList= [];
    public static $facilityList= [];
    public static $sportsRecreationList= [];
    public static $extraHotelInfoList= [];
    
    public function __construct($name = null) {
        parent::__construct('hotel-room-form');
        
         /**
         * MAIN IMAGE
         */
        $this->add([
            'name' => 'main_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'main-image',
                'class' => 'form-control common-image-file',
                'data-level-name' => 'main-image',
                'data-type' => 'hotel'
            ],
            'options' => [
                'label' => 'Hotel Room Main Image (Multiple)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * GALLERY IMAGE
         */
        $this->add([
            'name' => 'gallery_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'gallery-image',
                'class' => 'form-control common-image-file',
                'data-level-name' => 'gallery-image',
                'data-type' => 'hotel'
            ],
            'options' => [
                'label' => 'Hotel Room Gallery Image (Multiple)<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         $this->add([
            'name' => 'module_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'module-id'
            ],
        ]);
        
          /**
           * Allocation Tab
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'allocation-hotel-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
        
        $this->add([
            'name' => 'category_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'category-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room Category<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomCategoryList
            ],
        ]);
        
        
        $this->add([
            'name' => 'room_type_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'room-type-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room Type<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomTypeList
            ],
        ]);
        
        
        /**         
         * Facility List
         */
        $this->add([
            'name' => 'facility_type_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'facility-type-id',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Room Facility<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$facilityList
            ],
        ]);
        
         /**         
         * Room Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Room Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);     
        /**         
         * Minimum Staying
         */
        $this->add([
            'name' => 'minimum_staying',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minimum-staying',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Minimum Staying<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**         
         * Maximum Adult
         */
        $this->add([
            'name' => 'maximum_adult',
            'type' => Text::class,
            'attributes' => [
                'id' => 'maximum-adult',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Maximum Adult<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**         
         * Maximum Adult
         */
        $this->add([
            'name' => 'maximum_children',
            'type' => Text::class,
            'attributes' => [
                'id' => 'maximum-children',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Maximum Children<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**         
         * Extra Bed
         */
        $this->add([
            'name' => 'extra_bed',
            'type' => Text::class,
            'attributes' => [
                'id' => 'extra-bed',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Extra Bed<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * 
         * DESCRIPTION
         */
        $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
       
        
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'hotel_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'category_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'room_type_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'facility_type_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Room Facility'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Room Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'minimum_staying' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Minimum Staying'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maximum_adult' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Maximum Adult'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'maximum_children' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Maximum Children'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'extra_bed' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Extra Bed'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           
            'description' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]           
        ];
    }

}
