<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelForm extends Form implements InputFilterProviderInterface {

    public static $hotel_category = [];
    public static $property_type = [];

    public function __construct($name = null) {
        parent::__construct('hotel-form');

        /**
         * General Information Tab
         * Hotel Code
         */
        $this->add([
            'name' => 'code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'code',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * 
         * Hotel Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'hotel_name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Destination | Area City
         */
        $this->add([
            'name' => 'hotel_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'destination_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'hotel-id',
                'class' => 'form-control'
            ],
        ]);



        /**
         * 
         * Property Type
         */
        $this->add([
            'name' => 'property_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'property-type',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
                'style' => 'display: none'
            ],
            'options' => [
                'label' => 'Property Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$property_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Property Type--',
            ],
        ]);
        /**
         * Hotel Category
         * 
         */
        $this->add([
            'name' => 'hotel_category',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-category',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Category <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$hotel_category,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Hotel Category--',
            ],
        ]);

       
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [            
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'hotel_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],           
            'property_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Property Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'hotel_category' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],  
            
        ];
    }
}