<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelAllocationForm extends Form implements InputFilterProviderInterface {
    
    public static $hotel_list= [];
    public static $roomCategoryList= [];

    public function __construct($name = null) {
        parent::__construct('hotel-allocation-form');
        
          /**
           * Allocation Tab
         */
        
        $this->add([
            'name' => 'hotel_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'allocation-hotel-id',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Hotel Name <span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$hotel_list
            ],
        ]);
        
        /**         
         * From Date
         */
        $this->add([
            'name' => 'allocation_from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allocation-from-date',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'From Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * To Date
         */
        $this->add([
            'name' => 'allocation_to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allocation-to-date',
                'class' => 'form-control datepicker',
                'maxlength' => 15,
            ],
            'options' => [
                'label' => 'To Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * 
         * Allocation
         */
        $this->add([
            'name' => 'allocation_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allocation-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Allocation<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * Cut Off Days
         */
        $this->add([
            'name' => 'allocation_cut_off_days',
            'type' => Text::class,
            'attributes' => [
                'id' => 'allocation-cut-off-days',
                'class' => 'form-control',
                'maxlength' => 3,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Cut Off Days<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        $this->add([
            'name' => 'allocation_room_category',
            'type' => Select::class,
            'attributes' => [
                'id' => 'allocation-room-category',
                'class' => 'form-control',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Room Category<span style="color: red"> *</span>',
                'disable_inarray_validator' => true,
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select Name--',
                'value_options' =>self::$roomCategoryList
            ],
        ]);        
        
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'hotel_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'allocation_from_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'allocation_to_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter To Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'allocation_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Allocation',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]                    
                ]
            ],
            'allocation_cut_off_days' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Cut Off Days'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'allocation_room_category' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]            
        ];
    }

}
