<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    Radio,
    File,
    Time
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class HotelAddForm extends Form implements InputFilterProviderInterface {

    public static $hotel_category = [];
    public static $property_type = [];

    public function __construct($name = null) {
        parent::__construct('hotel-add-form');

        /**
         * General Information Tab
         * Hotel Code
         */
        $this->add([
            'name' => 'code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'code',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * 
         * Hotel Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Destination | Area City
         */
        $this->add([
            'name' => 'hotel_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-city',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'destination_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'destination-city-id',
                'class' => 'form-control'
            ],
        ]);

        /**
         * 
         * 
         * Hotel Name
         */
        $this->add([
            'name' => 'location',
            'type' => Text::class,
            'attributes' => [
                'id' => 'location',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Location<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Hotel URL
         */
        $this->add([
            'name' => 'url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'url',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Url<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Property Type
         */
        $this->add([
            'name' => 'property_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'property-type',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
                'style' => 'display: none'
            ],
            'options' => [
                'label' => 'Property Type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$property_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Property Type--',
            ],
        ]);
        /**
         * Hotel Category
         * 
         */
        $this->add([
            'name' => 'hotel_category',
            'type' => Select::class,
            'attributes' => [
                'id' => 'hotel-category',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => true,
                'data-live-search' => true,
            ],
            'options' => [
                'label' => 'Category <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$hotel_category,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Hotel Category--',
            ],
        ]);

        /**
         * Total Floors
         * 
         */
        $this->add([
            'name' => 'total_floor',
            'type' => Text::class,
            'attributes' => [
                'id' => 'total-floor',
                'class' => 'form-control',
                'maxlength'=>4,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Total Floor <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * No. of Single Rooms
         */
        $this->add([
            'name' => 'total_rooms_single',
            'type' => Text::class,
            'attributes' => [
                'id' => 'total-rooms_single',
                'class' => 'form-control',
                'maxlength'=>4,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Single Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * 
         * No. of Single Rooms
         */
        $this->add([
            'name' => 'total_rooms_double',
            'type' => Text::class,
            'attributes' => [
                'id' => 'total-rooms_double',
                'class' => 'form-control',
                'maxlength'=>4,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Double Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * No. of Twin Rooms
         */
        $this->add([
            'name' => 'total_rooms_twin',
            'type' => Text::class,
            'attributes' => [
                'id' => 'total-rooms-twin',
                'class' => 'form-control',
                'maxlength'=>4,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Twin Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * 
         * No. of Disabled Rooms
         */
        $this->add([
            'name' => 'total_rooms_disabled',
            'type' => Text::class,
            'attributes' => [
                'id' => 'total-rooms-disabled',
                'class' => 'form-control',
                'maxlength'=>4,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Disabled Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Total Conference Halls
         */
        $this->add([
            'name' => 'total_conference_halls',
            'type' => Select::class,
            'attributes' => [
                'id' => 'total-conference-halls',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Conference Halls<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select -- ',
                'value_options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10'
                ],
            ],
        ]);
        /**
         * 
         * Total Board Rooms
         */
        $this->add([
            'name' => 'total_board_rooms',
            'type' => Select::class,
            'attributes' => [
                'id' => 'total-board-rooms',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Board Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select -- ',
                'value_options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10'
                ],
            ],
        ]);
        /**
         * 
         * Total Party Lawns
         */
        $this->add([
            'name' => 'total_party_lawns',
            'type' => Select::class,
            'attributes' => [
                'id' => 'total-party-lawns',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Party Lawns<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select -- ',
                'value_options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10'
                ],
            ],
        ]);
        
         /**         
         * InterConneccted Total Rooms
         */
        $this->add([
            'name' => 'interconnected_total_rooms',
            'type' => Text::class,
            'attributes' => [
                'id' => 'interconnected-total-rooms',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Interconnect Rooms<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Check In Time
         *
         */
        $this->add([
            'name' => 'check_in_time',
            'type' => text::class,
            'attributes' => [
                'id' => 'check-in-time',
                'class' => 'form-control clockpicker'
            ],
            'options' => [
                'label' => 'Check In Time <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Check Out Time
         *
         */
        $this->add([
            'name' => 'check_out_time',
            'type' => text::class,
            'attributes' => [
                'id' => 'check-out-time',
                'class' => 'form-control clockpicker'
            ],
            'options' => [
                'label' => 'Check Out Time <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Description
         *
         */
        $this->add([
            'type' => Textarea::class,
            'name' => 'description',
            'attributes' => [
                'id' => 'description',
                'placeholder' => 'Content',
                'class' => 'form-control editor'
            ],
            'options' => [
                'label' => 'Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        $this->add([
            'type' => Checkbox::class,
            'name' => 'featured',
            'attributes' => [
                'id' => 'featured',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Featured',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);

        $this->add([
            'type' => Checkbox::class,
            'name' => 'preferred',
            'attributes' => [
                'id' => 'preferred',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Preferred',
                'use_hidden_element' => true,
                'checked_value' => '1',
                'unchecked_value' => '0',
            ]
        ]);
        
        /**         
         * Hotel Telephone No
         */
        $this->add([
            'name' => 'telephone',
            'type' => Text::class,
            'attributes' => [
                'id' => 'telephone',
                'class' => 'form-control',
                'maxlength' => 15,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Hotel Telephone<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * 
         * 
         * Hotel Fax
         */
        $this->add([
            'name' => 'fax',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fax',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Fax<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
       
        
        /**
         * 
         * 
         * Hotel Email Address
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * 
         * Hotel Building Name
         */
        $this->add([
            'name' => 'building_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'building-name',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Building Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        /**
         * 
         * 
         * Hotel Building Number
         */
        $this->add([
            'name' => 'building_number',
            'type' => Text::class,
            'attributes' => [
                'id' => 'building-number',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Hotel Building No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Address
         *
         */
        $this->add([
            'type' => Text::class,
            'name' => 'address',
            'attributes' => [
                'id' => 'pac-input',
                'placeholder' => 'Content',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * 
         * Postal Code
         */
        $this->add([
            'name' => 'postal_code',
            'type' => Text::class,
            'attributes' => [
                'id' => 'postal-code',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Postal Code<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * 
         * Latitude
         */
        $this->add([
            'name' => 'latitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'latitude',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Latitude<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Longitude
         */
        $this->add([
            'name' => 'longitude',
            'type' => Text::class,
            'attributes' => [
                'id' => 'longitude',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Longitude<span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id'
            ],
        ]);

        /**
         * 
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [            
            'name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'hotel_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'url' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Url'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'property_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Property Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'hotel_category' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Hotel Category'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_floor' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Floors'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_rooms_single' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_rooms_double' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_rooms_twin' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_rooms_disabled' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter No. of Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_conference_halls' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Conference Halls'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_board_rooms' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Board Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'total_party_lawns' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Party Lawns'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'interconnected_total_rooms' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Interconnected Rooms'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'check_in_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Check In Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'check_out_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Check Out Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'location' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Location'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'featured' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Location'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'preferred' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Location'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'telephone' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Telephone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'fax' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Fax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please Enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'building_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Building Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'building_number' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Buliding No'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'postal_code' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Postal Code'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'latitude' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Latitude'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'longitude' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Longitude'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
