<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};

class HeaderFooterForm extends Form {

    public function __construct($name = null) {

        parent::__construct('header-footer-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Frontend Header Logo
         */
        $this->add([
            'name' => 'frontend_header_logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'frontend-header-logo-id',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'upload_btn btnbtn-blue btn-primary',

            ],
            'options' => [
                'label' => 'Frontend Header Logo',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Admin Header Logo
         */
        $this->add([
            'name' => 'admin_header_lodo',
            'type' => File::class,
            'attributes' => [
                'id' => 'admin-header-logo-id',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'upload_btn btnbtn-blue btn-primary',

            ],
            'options' => [
                'label' => 'Admin Header Logo ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Admin Dashboard Logo
         */
        $this->add([
            'name' => 'admin_dashboard_logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'admin-dashboard-logo-id',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'upload_btn btnbtn-blue btn-primary',

            ],
            'options' => [
                'label' => 'Admin Dashboard Logo',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Frontend Favicon
         */
        $this->add([
            'name' => 'frontend_favicon',
            'type' => File::class,
            'attributes' => [
                'id' => 'frontend-favicon-id',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'upload_btn btnbtn-blue btn-primary',

            ],
            'options' => [
                'label' => 'Frontend Favicon',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Admin Favicon
         */
        $this->add([
            'name' => 'admin_favicon',
            'type' => File::class,
            'attributes' => [
                'id' => 'admin-favicon-id',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'upload_btn btnbtn-blue btn-primary',

            ],
            'options' => [
                'label' => 'Admin Favicon',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Admin Footer Name
         */
           $this->add([
            'name' => 'admin_footer',
            'type' => Text::class,
            'attributes' => [
                'id' => 'admin-footer',
                'placeholder' => 'Eicrasoft Ltd',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Admin Footer Name :',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

           /**
         *
         * Admin Footer URL
         */
           $this->add([
            'name' => 'admin_footer_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'admin-footer-url',
                'placeholder' => 'www.bookingcabs.com',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Admin Footer URL:',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

           /**
         *
         * Frontend Footer Name
         */
           $this->add([
            'name' => 'frontend_footer',
            'type' => Text::class,
            'attributes' => [
                'id' => 'frontend-footer',
                'placeholder' => 'Powered by Traco Web',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Frontend Footer Name:',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
           /**
         *
         * Frontend Footer URL
         */

           $this->add([
            'name' => 'frontend_footer_url',
            'type' => Text::class,
            'attributes' => [
                'id' => 'frontend-footer-url',
                'placeholder' => 'www.bookingcabs.com',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Frontend Footer URL:',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

           /**
         *
         * button System Backup
         */
         $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],

        ]);

         /**
         *
         * button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],

        ]);

          /**
         *
         * button reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],

        ]);

         /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'header-footer-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#header-footer-form', event);"
            ],
        ]);



    }

}
