<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;

class FareAddCancellationFeesForm extends Form {

     public static $cancellation_type = [];

     public function __construct($name = null) {

        parent::__construct('cancellation-fees');

        $this->setAttribute('method', 'post');


        $this->add([
            'name' => 'cancellation_fees_id',
            'type' => Hidden::class,
          ]);


        $this->add([
            'name' => 'waiting_charge_id',
            'type' => Hidden::class,
          ]);

          $this->add([
            'name' => 'pre_waiting_charge_id',
            'type' => Hidden::class,
          ]);

        /**
         *
         * cancellation fees
         */
          $this->add([
            'name' => 'cancellation_fees[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cancellation_fees',
                'placeholder' => '150',
                'class' => 'form-control',
                'maxlength' =>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Cancellation Fees',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

 /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'cancellation_master_id[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-master-id',
                'placeholder' => '',
                'class' => 'form-control cancel-master'
            ],
            'options' => [
                'label' => 'Cancellation',
                'value_options' => self::$cancellation_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);

         /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'cancellation_type[]',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cancellation-type',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Cancellation Type',
                'value_options' => [
                    'Rs' => 'Rs',
                    '%' => '%'
                ],
                'disable_inarray_validator' => true,
                'empty_option' => '--Select--',
            ],
        ]);
           /**
         *
         * Minutes upto
         */
          $this->add([
            'name' => 'waiting_time_minutes_upto[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minutes-upto-id',
                'placeholder' => '15',
                'class' => 'form-control',
                'maxlength'=>'3',
                "onkeypress"=> "return isNumber(event)"

            ],
            'options' => [
                'label' => 'Minutes Up To',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

           /**
         *
         * Fees
         */
            $this->add([
            'name' => 'waiting_time_fees[]',
                'type' => Text::class,
            'attributes' => [
                'id' => 'fee-id',
                'placeholder' => '120',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Fee',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


             /**
         *
         * cancellation fees
         */
              $this->add([
            'name' => 'waiting_time_fees_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'waiting-time-fees-add-id',
                'placeholder' => 'Add',
                'class' => 'btn btn-info form-control ',
            ],

        ]);


               /**
         *
         * pre_minutes_upto
         */
           $this->add([
            'name' => 'pre_waiting_minutes_upto[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pre-minutes-upto-id',
                'placeholder' => '15',
                'class' => 'form-control',
                'maxlength' =>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Pre Minutes Up To',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

            /**
         *
         * Fees
         */
            $this->add([
            'name' => 'pre_waiting_fee[]',
                'type' => Text::class,
            'attributes' => [
                'id' => 'pre_waiting_fees_1',
                'placeholder' => '50',
                'class' => 'form-control',
                'maxlength' =>5,
                'onkeypress'=>"return isNumber(event)"

            ],
            'options' => [
                'label' => 'Fee',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

            /**
         *
         * Add
         */
              $this->add([
            'name' => 'prewaiting_fees_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'prewaiting-fees-add-id',
                'placeholder' => 'Add',
                'class' => 'addprewaiting_on_plus no-padding ',
            ],

        ]);


         /**
         *
         * save
         */
              $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'cancellation-fees-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                'value' =>'Save & Next',
                'onclick'=>"submitForm('#cancellation-fees', event);"

            ],

        ]);


  }
}