<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Date
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class FareAddBasicForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('basic-fare');

        $this->setAttribute('method', 'post');

        /**
         *
         * Basic tax
         */
        $this->add([
            'name' => 'sgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'sgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'SGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * krishi kalyan cess
         */
        $this->add([
            'name' => 'cgst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cgst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'CGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * swatch bharat cess
         */
        $this->add([
            'name' => 'igst',
            'type' => Text::class,
            'attributes' => [
                'id' => 'igst',
                'placeholder' => '5',
                'class' => 'form-control',
                'maxlength' => 5,
                'onkeypress' => "return isNumberDecimal(event)"
            ],
            'options' => [
                'label' => 'IGST',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'basic-fare-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                'Value' => 'Save & Next',
                'onclick' => "submitForm('#basic-fare', event);"
            ],
        ]);

        /**
         *
         * next
         */
        $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',
                'placeholder' => 'Next',
                'class' => 'btn btn-info form-control margin-bottom10px',
                'value' => 'Next'
            ],
        ]);

        /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'tax_fare_id',
            'type' => Hidden::class,
          ]);

         $this->add([
            'name' => 'tax_fare_setting_id',
            'type' => Hidden::class,
          ]);
    }

    public function getInputFilterSpecification() {
        return [
            'sgst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter SGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'cgst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter CGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'igst' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter IGST Tax'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
