<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;


class DriverLoginForm extends Form {

    public function __construct($name = null) {

        parent::__construct('driver-login-form');
        $this->setAttribute('method', 'post');
        
        /**
         * 
         * Login ID
         */
        $this->add([
            'name' => 'login_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'login-id',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Login ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Password
         */
        $this->add([
            'name' => 'password',
             'type' => Text::class,
            'attributes' => [
                'id' => 'password',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 
        
        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
             'type' => Text::class,
            'attributes' => [
                'id' => 'confirm-password',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
             'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]); 
    }

}
