<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Date,
    Submit,
    Text
};


class DataSearchForm extends Form {

    public function __construct($name = null) {

        parent::__construct('data-search-form');
        $this->setAttribute('method', 'post');

        /**
         * FROM DATE
         */
        $this->add([
            'name' => 'from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'from-date',
                'placeholder' => '',
                'class' => 'form-control from_date_search'
            ],
            'options' => [
                'label' => 'From Date',
            ],
        ]);

        /**
         * TO DATE
         */
        $this->add([
            'name' => 'to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'to-date',
                'placeholder' => '',
                'class' => 'form-control to_date_search'
            ],
            'options' => [
                'label' => 'To Date',
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-new-vehile btn-warning'
            ],
        ]);

    }

}
