<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class CronScheduleForm extends Form implements InputFilterProviderInterface {
    
    public static $cron_master = [];
    public static $user_roles = [];
    
    
    public function __construct($name = null) {
        
        parent::__construct('cron-form');
        $this->setAttribute('method', 'post');

        /**
         * Cron Id
         */
         $this->add([
            'name' => 'cron_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cron-id',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Cron<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select--',
                'disable_inarray_validator' => true,
                'value_options' => self::$cron_master
            ],
        ]);
         
        /**
         * Cron Id
         */
         $this->add([
            'name' => 'role_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'role-id',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Role<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'empty_option' => '--Select--',
                'disable_inarray_validator' => true,
                'value_options' => self::$user_roles
            ],
        ]);

     
        /**
         * Remark/Request
         */
        $this->add([
            'name' => 'day',
            'type' => Text::class,
            'attributes' => [
                'id' => 'day',
                'placeholder' => '',
                'class' => 'form-control',
                'maxlength' => 2,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'Days<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       


        /**
         * Search
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
        ]);

      
       /**
         *
         * save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'submit',
                'placeholder' => 'Save',
                'class' => 'btn btn-primary pull-right',
                'Value' => 'Save',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'cron_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Cron'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'role_id' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Role'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'day' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Day'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
