<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class CreditRequestSearchForm extends Form {

    public static $paymentModeList = ['Cheque'=>'Cheque','Cash Deposit'=>'Cash Deposit','Online Transfer'=>'Online Transfer','Demand Draft'=>'Demand Draft'];
    public static $status = ['0'=>'Pending','1'=>'Approved','2'=>'Audited'];

    public function __construct($name = null) {

        parent::__construct('credit-request-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Payment Ref No
         */
        $this->add([
            'name' => 'payment_ref_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'payment-ref-no',
                'placeholder' => 'Ref No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Ref. ID',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver Name
         */
        $this->add([
            'name' => 'user_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'user-name',
                'placeholder' => 'Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposit Amount
         */
        $this->add([
            'name' => 'deposit_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        $this->add([
            'name' => 'payment_mode',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-mode',
                'class' => 'form-control input'
            ],
            'options' => [
                'label' => 'Payment Mode',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$paymentModeList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        $this->add([
            'name' => 'status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'status',
                'class' => 'form-control input'
            ],
            'options' => [
                'label' => 'Status',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$status,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

    }
}
