<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Date,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class CreditLimitForm extends Form implements InputFilterProviderInterface {

     public static $users = [];

    public function __construct($name = null) {

        parent::__construct('credit-limit');
        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);


         /**
         *
         * City
         */
       $this->add([
            'name' => 'user_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-name',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control'
            ],
            'options' => [
                'label' => 'User',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
                'value_options' => self::$users,

            ],
        ]);



        /**
         *
         * Credit Limit Amount
         */
        $this->add([
            'name' => 'credit_limit_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'credit-limit-amount',
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Credit Limit Amount',
            ],
        ]);

        /**
         * From Date
         */
        $this->add([
            'name' => 'from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'from-date',
                'class' => 'form-control inputchange from',
                'readonly'=>true
            ],
            'options' => [
                'label' => 'From Date<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposit Date
         */
        $this->add([
            'name' => 'to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'to-date',
                'class' => 'form-control inputchange to',
                'readonly'=>true
            ],
            'options' => [
                'label' => 'To Date<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Id
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'id',
            ],
        ]);


        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);






    }
     public function getInputFilterSpecification() {
        return [
            'user_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select User'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'credit_limit_amount' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Credit Limit Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'from_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter From date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'to_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter To date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],





        ];
    }


}
