<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class CityPageForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];

    public function __construct($name = null) {

        parent::__construct('city-page');

        $this->setAttribute('method', 'post');

        /**
         *
         * city
         */
        $this->add([
            'name' => 'fare_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fare-city',
                'placeholder' => '',
                'class' => 'form-control oneway-source-distance-city',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'fare_city_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'fare-city-id',
            ],
        ]);
        
        /**
         *
         * Upload Image...
         */
        $this->add([
            'name' => 'city_page_image',
            'type' => File::class,
            'attributes' => [
                'id' => 'city-page-image',
                'class' => 'form-control'
            ],
            'options' => [
                 'label' => 'Image',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);


         $this->add([
            'name' => 'page_title',
             'type' => Text::class,
            'attributes' => [
                'id' => 'page-title',
                'placeholder' => 'Page Title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Page Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Meta Title.....
         */
        $this->add([
            'name' => 'meta_title',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-title',
                'placeholder' => 'Meta Title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);       
        
         /**
         *
         * Meta Title.....
         */
        $this->add([
            'name' => 'meta_keywords',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meta-keywords',
                'placeholder' => 'Keywords',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Keywords<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Content...
         */
        $this->add([
            'name' => 'page_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'page-desc',
                'placeholder' => 'Content',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Meta Description.....
         */
        $this->add([
            'name' => 'meta_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'meta-desc',
                'placeholder' => 'Meta Description',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Meta Description<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * No Of Sightseeing
         */
        $this->add([
            'name' => 'no_of_sightseeing',
            'type' => Text::class,
            'attributes' => [
                'id' => 'no-of-sightseeing',
                'placeholder' => 'No of Sightseeing',
                'class' => 'form-control',
                'value'=>0,
                'maxlength' => 2,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'No of Sightseeing<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * No Of Hotels
         */
        $this->add([
            'name' => 'no_of_hotels',
            'type' => Text::class,
            'attributes' => [
                'id' => 'no-of-hotels',
                'placeholder' => 'No of Hotels',
                'class' => 'form-control',
                'value'=>0,
                'maxlength' => 2,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'No of Hotels<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         *
         * No Of Offers
         */
        $this->add([
            'name' => 'no_of_offers',
            'type' => Text::class,
            'attributes' => [
                'id' => 'no-of-offers',
                'placeholder' => 'No of Offers',
                'class' => 'form-control',
                'value'=>0,
                'maxlength' => 2,
                'onkeypress' => "return isNumber(event)"
            ],
            'options' => [
                'label' => 'No of Offers<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);
       
        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-type',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_city_page',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-city-page',
                'placeholder' => 'Add City Page',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'fare_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Page Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'page_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Page Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Meta Title'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_keywords' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Meta Keywords'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meta_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Meta Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'no_of_sightseeing' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter No of Sighgtseeing'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'no_of_hotels' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter No of Sighgtseeing'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'no_of_offers' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter No of Sighgtseeing'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
