<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Date,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class CacheForm extends Form {

    public static $cache_adapter=[];

    public function __construct($name = null) {
        parent::__construct('cache-form');
        $this->setAttribute('method', 'post');


          /**
         *
         * Select Cache Adapter
         */
           $this->add([
            'name' => 'cache_adapter',
           'type' => Select::class,
            'attributes' => [
                'id' => 'cache-adapter',
                'placeholder' => '',
                'class' => 'form-control '
            ],
            'options' => [
                'label' => 'Select Cache Adapter',
                'value_options' => self::$cache_adapter
            ],
        ]);

           /**
         *
         *Cache Directory
         */
          $this->add([
            'name' => 'cache_directory',
            'type' => Text::class,
            'attributes' => [
                'id' => 'cache-directory',
                'placeholder' => 'cache directory',
                'class' => 'form-control',

            ],
            'options' => [
                'label' => 'Cache Directory',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



          /**
         *
         *button System Backup
         */
          $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],

        ]);

          /**
         *
         *button Restore
         */
          $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],

        ]);

          /**
         *
         *button Reset
         */
          $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],

        ]);

          /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'cache-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#cache-form', event);"
            ],
        ]);

    }

}
