<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Text;
use Zend\Form\Element\Submit;

class BookingVehicleSearchForm extends Form {

    public static $vehicletype =[];

    public function __construct($name = null) {

        parent::__construct('booking-vehicle-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Vehicle Tab start
         * Vehicle Type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' =>Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'col-sm-12 col-lg-12 inputfild name valid form-control'
            ],
            'options' => [
                'label' => 'Vehicle Type<span style="color: red"> *</span>',
                'empty_option' => 'Select Vehicle Type',
                'value_options' => self::$vehicletype,
            ],
        ]);

        /**
         * External Reference
         */
        $this->add([
            'name' => 'external_reference',
            'type' => Text::class,
            'attributes' => [
                'id' => 'external-reference',
                'placeholder' => 'External Reference',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'External Reference<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Vehicle Tab end
         * License Plate
         */
        $this->add([
            'name' => 'vehicle_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-no',
                'placeholder' => 'Vehicle No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'License Plate<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-warning booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-warning'
            ],
        ]);
    }

}
