<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Textarea,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class BookingMappingForm extends Form implements InputFilterProviderInterface {

    public static $booking_type = [];
    public static $booking_mode_type = [];

    public function __construct($name = null) {

        parent::__construct('mapping-search-type');

        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);


        /**
         *
         * booking_mode_type
         */
        $this->add([
            'name' => 'booking_mode_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-mode-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Mode',
                'value_options' => self::$booking_mode_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Mode--',
            ],
        ]);


        /**
         *
         * vehicle type_name
         */
        $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'Vehicle Type',
            ],
        ]);




        /**
         *
         * Search Button
         */
        $this->add([
            'name' => 'search_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-vehicle-type',
                'placeholder' => 'Search',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Search'
            ],
        ]);


        $this->add([
            'name' => 'add_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'addvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'edit_vehicle_type',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'editvehicle-type',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);

        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'booking_mode_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Booking Mode Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ]
        ];
    }

}
