<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Text;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Select;

class BookingLocationSearchForm extends Form {
    public static $stateList =[];
    public function __construct($name = null) {

        parent::__construct('booking-location-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Location Tab start
         * Country
         */
        $this->add([
            'name' => 'state_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-name',
                'placeholder' => 'State',
                'class' => 'form-control inputchange fare-state'
            ],
            'options' => [
                'label' => 'State<span style="color: red"> *</span>',
                'value_options' => self::$stateList,
                'empty_option' => 'Select',
            ],
        ]);


        /**
         * City
         */
        $this->add([
            'name' => 'city_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-name',
                'placeholder' => 'City',
                'class' => 'form-control inputchange fare-city'
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'empty_option' => 'Select',
            ],
        ]);


        /**
         * Pickup
         */
        $this->add([
            'name' => 'pickupaddress',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-address',
                'placeholder' => 'Pickup',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Pickup<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Location Tab end
         * Drop Off
         */
        $this->add([
            'name' => 'drop_area',
            'type' => Text::class,
            'attributes' => [
                'id' => 'drop-address',
                'placeholder' => 'Drop Off',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Drop Off<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-warning booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-warning'
            ],
        ]);
    }

}
