<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

class BidSearchForm extends Form {

    public static $bookingType =[];
    public static $vehicletype =[];

    public function __construct($name = null) {

        parent::__construct('bid-search-form');
               /**
         *
         * Source Station
         */
        $this->add([
            'name' => 'source_station',
             'type' => Text::class,
            'attributes' => [
                'id' => 'source-station',
                'placeholder' => 'Source',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Source Station<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Destination Station
         */
        $this->add([
            'name' => 'destination_station',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-station',
                'placeholder' => 'Destination',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Destination<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Source Value
         */
        $this->add([
            'name' => 'source_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'source-value',
                'class' => 'form-control'
            ],
        ]);
        /**
         * Destination Value
         */
        $this->add([
            'name' => 'destination_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'destination-value',
                'class' => 'form-control'
            ],
        ]);

        /**
         *
         * Journey Date
         */
        $this->add([
            'name' => 'journey_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'journey-date',
                'placeholder' =>'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker'
            ],
            'options' => [
                'label' => 'Journey Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Vehicle Tab start
         * Vehicle Type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' =>Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Vehicle Type<span style="color: red"> *</span>',
                'empty_option' => 'Select Vehicle Type',
                'value_options' => self::$vehicletype,
            ],
        ]);

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'demo-default select-state selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$bookingType,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);

        /**
         * Initial Request Data Since
         */
        $this->add([
            'name' => 'from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'from-date',
                'placeholder' => 'Since',
                'class' => 'form-control inputchange from'
            ],
            'options' => [
                'label' => 'Initial Request Data<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Initial Request Data To
         */
        $this->add([
            'name' => 'to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'to-date',
                'placeholder' => 'To',
                'class' => 'form-control inputchange to'
            ]
        ]);


        /**
         *
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);
    }

}
