<?php
namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;

class BidAddForm extends Form implements InputFilterProviderInterface {
     public static $vehicletype = [];


    public function __construct($name = null) {

        parent::__construct('bid-add-form');

          $this->setAttribute('method', 'post');

        /**
         *
         * Source Station
         */
        $this->add([
            'name' => 'source_station',
             'type' => Text::class,
            'attributes' => [
                'id' => 'source-station',
                'placeholder' => 'Source',
                'class' => 'form-control source-distance-cityid'
            ],
            'options' => [
                'label' => 'Source Station<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Destination Station
         */
        $this->add([
            'name' => 'destination_station',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-station',
                'placeholder' => 'Destination',
                'class' => 'form-control source-distance-cityid'
            ],
            'options' => [
                'label' => 'Destination<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Source Value
         */
        $this->add([
            'name' => 'source_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'source-value'
            ],
        ]);
         /**
         * Distance City Id
         */
        $this->add([
            'name' => 'distance_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'distance-city-id'
            ],
        ]);

         /**
         * Route Id
         */
        $this->add([
            'name' => 'route_id',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'route-id'
            ],
        ]);

        /**
         *
         * vehicle type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'label' => 'Vehicle Type',
                'value_options' => self::$vehicletype,
                'empty_option' => 'Select Vehicle Type',
            ],
        ]);


        /**
         * Destination Value
         */
        $this->add([
            'name' => 'destination_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'destination-value'
            ],
        ]);

        /**
         * Kill Metor Value
         */
        $this->add([
            'name' => 'kilo_metor',
            'type' => Text::class,
            'attributes' => [
                'value' => '',
                'id' => 'kilo-metor',
                'Size'=>3,
                'readonly'=>'readonly'
            ],
        ]);



        /**
         *
         * Cab No.
         */
        /* $this->add([
            'name' => 'cab_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'cab-no',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Cab No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); */

        /**
         *
         * Fare
         */
        $this->add([
            'name' => 'fare',
             'type' => Text::class,
            'attributes' => [
                'id' => 'fare',
                'placeholder' => '2000',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Fare<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Extra Charge
         * Toll
         */
        $this->add([
            'name' => 'toll',
            'type' => Text::class,
            'attributes' => [
                'id' => 'toll',
                'placeholder' => '100',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Extra Charge<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Extra Charge
         * Parking
         */
        $this->add([
            'name' => 'parking',
             'type' => Text::class,
            'attributes' => [
                'id' => 'parking',
                'placeholder' => '50',
                'class' => 'form-control'
            ]
        ]);

        /**
         * Extra Charge
         * DA
         */
        $this->add([
            'name' => 'da',
            'type' => Text::class,
            'attributes' => [
                'id' => 'da',
                'placeholder' => '200',
                'class' => 'form-control'
            ]
        ]);

        /**
         * Kilo-Meter
         * Fixed KM
         */
        $this->add([
            'name' => 'fixed_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fixed-km',
                'placeholder' => '250 km',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Kilo-Meter<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Kilo-Meter
         * Extra KM
         */
        $this->add([
            'name' => 'extra_km',
             'type' => Text::class,
            'attributes' => [
                'id' => 'extra-km',
                'placeholder' => '12/km',
                'class' => 'form-control'
            ]
        ]);

        /**
         *
         * From
         */
        $this->add([
            'name' => 'journey_start_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'journey-start-date',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                'placeholder' =>'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * To
         */
        $this->add([
            'name' => 'journey_end_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'journey-end-date',
                'class' => 'form-control text-uppercase datepicker date-valid-format',
                'placeholder' =>'DD/MM/YYYY'
            ],
            'options' => [
                'label' => 'To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * From Time
         */
        $this->add([
            'name' => 'journey_start_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'journey-start-time',
                'class' => 'form-control clockpicker',
                 'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' => 'From<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * To Time
         */
        $this->add([
            'name' => 'journey_end_time',
             'type' => Text::class,
            'attributes' => [
                'id' => 'journey-end-time',
                'class' => 'form-control clockpicker',
                'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' => 'To<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Cab Release Time
         */
        $this->add([
            'name' => 'cab_release_time',
             'type' => Text::class,
            'attributes' => [
                'id' => 'cab-release-time',
                'class' => 'form-control',
                'placeholder' =>'HH:MM:SS'
            ],
            'options' => [
                'label' => 'Cab Release Time<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Save
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile',
            ],
        ]);
    }
    public function getInputFilterSpecification() {
        return [
            'source_station' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Source Station'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'destination_station' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Destination Station'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'vehicle_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Vehicle Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'fare' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Fare'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'fixed_km' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Fixed KM'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'extra_km' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Extra KM'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'journey_start_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill From Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'journey_end_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill To Date'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'journey_start_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill From Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'journey_end_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill To Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            ];
    }

}
