<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class AirportForm extends Form implements InputFilterProviderInterface {

     public static $city = [];

    public function __construct($name = null) {

        parent::__construct('airport');
        $this->setAttribute('method', 'post');

         /**
         *
         * status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'active',
            ],
            'options' => [
                'label' => '<span class="radio">Active</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => array(
                '1' => 'Active',
                '0' => 'In-Active',
            ),
            ],
        ]);


         /**
         *
         * City
         */
       $this->add([
            'name' => 'city_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'city-list',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

       $this->add([
            'name' => 'city_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'city-id',
                'class' => 'input form-control'
            ],
        ]);

        $this->add([
            'name' => 'state_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'state-id',
            ],
        ]);

         $this->add([
            'name' => 'country_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'country-id',
            ],
        ]);


        /**
         *
         * Airport/Railway Station
         */
        $this->add([
            'name' => 'airport_railway_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'airport-railway-id',
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Airport/Railway Station',
            ],
        ]);

        /**
         *
         * Meeting Point
         */
        $this->add([
            'name' => 'meeting_point',
            'type' => Text::class,
            'attributes' => [
                'id' => 'meeting-point',
                'placeholder' => '',
                'class' => 'input form-control'
            ],
            'options' => [
                'label' => 'Meeting Point',
            ],
        ]);

        /**
         *
         * Id
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'placeholder' => '',
                'class' => 'input form-control '
            ],
            'options' => [
                'label' => 'id',
            ],
        ]);


        $this->add([
            'name' => 'add_info',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-info',
                'placeholder' => 'Add Vehicle',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
                'value' => 'Save'
            ],
        ]);



    }
     public function getInputFilterSpecification() {
        return [
            'city_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'airport_railway_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Transfer name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'meeting_point' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Meeting point'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],





        ];
    }


}
