<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Select, Date, Email, Checkbox, File, Text, Textarea, Submit, Button, Hidden};
use Zend\Validator\{
    NotEmpty,
    Digits,
    EmailAddress,
    StringLength
};
use Zend\InputFilter\InputFilterProviderInterface;


class AddStaffForm extends Form implements InputFilterProviderInterface{


    public static $usertype = [];
    public static $department = [];
    public static $gender = ['Male' => 'Male', 'Female' => 'Female'];
    public static $countryprefix = [];
    public function __construct($name = null) {


        parent::__construct('add-staff-form');
        
        /**
         * Mobile no Prefix
         */
        $this->add([
            'name' => 'prefix_contact_no',
            'type' => Select::class,
            'attributes' => [
                'id' => 'prefix-contact-no',
                'class' => 'form-control',
                 'value'  => '91',
            ],
            'options' => [
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$countryprefix,
                'disable_inarray_validator' => true,
            ],
        ]);
        
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'form-control form-control input-border nationality-class'
            ],
            'options' => [
                 'label_options' => ['disable_html_escape' => true],
                'label' => 'Nationality<span style="color: red"> *</span>'
            ]
        ]);
        
         /**
         * Nationality Value
         */
        $this->add([
            'name' => 'nationality_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'nationality-value'
            ],
        ]);
       
        /**
         * User Id
         */
        
           $this->add([
            'name' => 'user_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'user-id',
                'class' => 'form-control'
                
            ],

        ]); 
           
        /**
         * Assign Role Id
         */
           
            $this->add([
            'name' => 'assign_role_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'assign-role-id',
                'class' => 'form-control'
                
            ],

        ]); 
         /**
         * User Role
         */
        $this->add([
            'name' => 'user_role',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user_role',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Role <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$usertype,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Role--',
            ]
        ]);

         /**
         * User Department
         */
        $this->add([
            'name' => 'department',
            'type' => Select::class,
            'attributes' => [
                'id' => 'department',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Department<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$department,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Department--',
            ]
        ]);


        /**
         * First Name
         */
        $this->add([
            'name' => 'first_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'first-name',
                'placeholder' => 'First Name',
                'class' => 'form-control input-border inputuppercase',
                'maxlength'=>60,
                'onkeypress' => "return isAlphaNumber(event)"
            ],
            'options' => [
                'label' => 'First Name<span style="color: red"> *</span>',
                //'class' => 'control-label col-sm-3 col-lg-3',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'type' => Text::class,
            'attributes' => [
                'maxlength'=> 60,
                'id' => 'last-name',
                'placeholder' => 'Last Name',
                'class' => 'input-border col-sm-6 col-lg-5 inputfild form-control inputuppercase',
                'onkeypress' => "return isAlphaNumber(event)"
            ], 'options' => [
                'label' => 'Last Name<span style="color: red"> *</span>',
                //'class' => 'control-label col-sm-3 col-lg-3',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);


        /**
         * Email
         */
        $this->add([
            'name' => 'email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'email',
                'placeholder' => 'user@gmail.com',
                'class' => 'form-control input-border inputlowercase personalemail'
            ],
            'options' => [
                'label' => 'Email<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

       
        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'contact-no',
                'class' => 'form-control input-border user-contact',
                'min' => 1,
                'max' => 10,
                'maxlength'=>10,
                'onkeypress'=>"return isNumber(event)"
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],

        ]);

        /**
         * Alt Contact No Prefix
         */
        $this->add([
            'name' => 'prefix_alt_contact_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'prefix-alt-contact-no',
                'value' => '+91',
                'disabled' => true,
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Alternate Contact No.'
            ],

        ]);

        /**
         * Gender
         */
        $this->add([
            'name' => 'gender',
            'type' => Select::class,
            'attributes' => [
                'id' => 'gender',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Gender<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$gender,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select Gender',
            ],
        ]);




        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-staff-form-btn',
                'class' => 'btn btn-info',
                'value' =>'Submit'
            ],

        ]);
        
        
        $this->add([
            'name' => 'registration_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control',
                 'value' =>'11'
            ],
        ]);


    }

    public function getInputFilterSpecification() {
   return [

        'first_name'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],


            'last_name'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Last Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],

       'email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
           'contact_no'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ],

      /**
         * User Role
         */
            'user_role'=>[
            'required' => TRUE,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Role'
                        ]
                    ],

                ],

            ]
        ],

       'gender'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please select Gender'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
       
       'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

        /**
         * Department
         */

            'department'=>[
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please select Department'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
       
       'prefix_contact_no'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
       
       'nationality'=>[
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ],
       
       
       


   ];

   }

}
